/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.jasig.portlet.announcements.service.UserPermissionCheckerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AdminController {
    @Autowired
    private IAnnouncementService announcementService;
    @Autowired
    private UserPermissionCheckerFactory userPermissionCheckerFactory = null;

    @RequestMapping
    public String showBaseView(RenderRequest request, Model model) {
        List<Topic> allTopics = this.announcementService.getAllTopics();
        ArrayList<Announcement> pendingAnnouncements = new ArrayList<Announcement>();
        if (UserPermissionChecker.isPortalAdmin((PortletRequest)request)) {
            model.addAttribute("allTopics", allTopics);
            model.addAttribute("portalAdmin", (Object)Boolean.TRUE);
            for (Topic t : allTopics) {
                pendingAnnouncements.addAll(t.getPendingAnnouncements());
            }
        } else {
            ArrayList<Topic> adminTopics = new ArrayList<Topic>();
            ArrayList<Topic> otherTopics = new ArrayList<Topic>();
            for (Topic t : allTopics) {
                UserPermissionChecker upChecker = this.userPermissionCheckerFactory.createUserPermissionChecker((PortletRequest)request, t);
                if (upChecker.isAdmin()) {
                    adminTopics.add(t);
                    pendingAnnouncements.addAll(t.getPendingAnnouncements());
                    continue;
                }
                if (upChecker.isModerator()) {
                    otherTopics.add(t);
                    pendingAnnouncements.addAll(t.getPendingAnnouncements());
                    continue;
                }
                if (!upChecker.isAuthor()) continue;
                otherTopics.add(t);
            }
            model.addAttribute("adminTopics", adminTopics);
            model.addAttribute("otherTopics", otherTopics);
            model.addAttribute("portalAdmin", (Object)Boolean.FALSE);
        }
        model.addAttribute("pendingAnnouncements", pendingAnnouncements);
        model.addAttribute("pendingAnnouncementCount", (Object)pendingAnnouncements.size());
        return "baseAdmin";
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }
}

