/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ApproveAjaxController
extends AbstractController
implements InitializingBean {
    private IAnnouncementService announcementService;
    @Autowired
    private EhCacheCacheManager cm = null;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long annId = Long.valueOf(request.getParameter("annId"));
        Boolean approval = Boolean.valueOf(request.getParameter("approval"));
        Announcement ann = this.announcementService.getAnnouncement(annId);
        Date startDisplay = ann.getStartDisplay();
        Date endDisplay = ann.getEndDisplay();
        if (endDisplay == null) {
            long aYearFromNow = System.currentTimeMillis() + 31536000000L;
            endDisplay = new Date(aYearFromNow);
        }
        Date now = new Date();
        int status = 3;
        if (startDisplay.after(now) && endDisplay.after(now) && approval.booleanValue()) {
            status = 0;
        } else if (startDisplay.before(now) && endDisplay.after(now) && approval.booleanValue()) {
            status = 2;
        } else if (endDisplay.before(now)) {
            status = 1;
        }
        ann.setPublished(approval);
        this.cm.getCacheManager().getCache("guestAnnouncementCache").flush();
        this.announcementService.addOrSaveAnnouncement(ann);
        return new ModelAndView("ajaxApprove", "status", (Object)status);
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setCm(EhCacheCacheManager cm) {
        this.cm = cm;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cm == null) {
            throw new BeanCreationException("Required cacheManager field was not set");
        }
    }
}

