/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.controller.IViewNameSelector;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.jasig.portlet.announcements.service.UserPermissionCheckerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ShowHistoryController {
    private static final Logger logger = Logger.getLogger(ShowHistoryController.class);
    @Autowired
    private IAnnouncementService announcementService;
    @Autowired
    private UserPermissionCheckerFactory userPermissionCheckerFactory = null;
    @Autowired(required=true)
    private final IViewNameSelector viewNameSelector = null;

    @RequestMapping(value={"VIEW"}, params={"action=showHistory"})
    protected String showHistory(Model model, RenderRequest request, @RequestParam(value="topicId") String topicId) throws Exception {
        Topic topic = this.announcementService.getTopic(Long.valueOf(Long.parseLong(topicId)));
        UserPermissionChecker upChecker = this.userPermissionCheckerFactory.createUserPermissionChecker((PortletRequest)request, topic);
        upChecker.validateCanEditTopic();
        Set annSet = topic.getAnnouncements();
        ArrayList<Announcement> annList = new ArrayList<Announcement>();
        for (Announcement ann : annSet) {
            if (ann.getEndDisplay().compareTo(Calendar.getInstance().getTime()) >= 0) continue;
            annList.add(ann);
        }
        if (annList != null) {
            Collections.sort(annList);
        }
        logger.info((Object)("number of announcements: " + annList.size()));
        model.addAttribute("user", (Object)upChecker);
        model.addAttribute("topic", (Object)topic);
        model.addAttribute("announcements", annList);
        model.addAttribute("now", (Object)new Date());
        return this.viewNameSelector.select((PortletRequest)request, "showHistory");
    }
}

