/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.model.validators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jasig.portlet.announcements.model.Announcement;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class AnnouncementValidator
implements Validator {
    private final boolean allowOpenEndDate;
    private final boolean allowEmptyMessage;

    public AnnouncementValidator() {
        this(false, false);
    }

    public AnnouncementValidator(boolean allowOpenEndDate, boolean allowEmptyMessage) {
        this.allowOpenEndDate = allowOpenEndDate;
        this.allowEmptyMessage = allowEmptyMessage;
    }

    public boolean supports(Class<?> clazz) {
        return Announcement.class.isAssignableFrom(clazz);
    }

    public void validate(Object obj, Errors errors) {
        GregorianCalendar calStart;
        Announcement test;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"addAnn.title.required.error");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"abstractText", (String)"addAnn.abstract.required.error");
        if (!this.allowEmptyMessage) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"message", (String)"addAnn.message.required.error");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"startDisplay", (String)"addAnn.start.required.error");
        if (!this.allowOpenEndDate) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"endDisplay", (String)"addAnn.end.required.error");
        }
        if ((test = (Announcement)obj).getLink() != null && !"".equals(test.getLink().trim()) && !this.validUrlFormat(test.getLink())) {
            errors.rejectValue("link", "addAnn.link.malformed.error");
        }
        Date startDisplay = test.getStartDisplay();
        Date endDisplay = test.getEndDisplay();
        Date now = new Date();
        if (startDisplay != null) {
            calStart = new GregorianCalendar();
            calStart.setTime(startDisplay);
            if (calStart.get(1) > 2050) {
                errors.rejectValue("startDisplay", "addAnn.toofaraway");
            }
            if (calStart.get(1) < 2008) {
                errors.rejectValue("startDisplay", "addAnn.tooold");
            }
        }
        if (endDisplay != null) {
            GregorianCalendar calEnd = new GregorianCalendar();
            calEnd.setTime(endDisplay);
            if (calEnd.get(1) > 2050) {
                errors.rejectValue("endDisplay", "addAnn.toofaraway");
            }
            if (calEnd.get(1) < 2008) {
                errors.rejectValue("endDisplay", "addAnn.tooold");
            }
        }
        if (endDisplay != null && startDisplay != null) {
            calStart = new GregorianCalendar();
            calStart.setTime(startDisplay);
            GregorianCalendar calEnd = new GregorianCalendar();
            calEnd.setTime(endDisplay);
            if (endDisplay.before(now) && !endDisplay.equals(startDisplay)) {
                errors.rejectValue("endDisplay", "addAnn.endDisplay.dateinpast");
            }
            if (startDisplay.after(endDisplay)) {
                errors.rejectValue("startDisplay", "addAnn.startDisplay.afterenddisplay");
            }
            if (startDisplay.equals(endDisplay)) {
                errors.rejectValue("endDisplay", "addAnn.endDisplay.sameAs.startDisplay");
            }
        }
    }

    private boolean validUrlFormat(String link) {
        URL test;
        try {
            test = new URL(link);
        }
        catch (MalformedURLException e) {
            return false;
        }
        link = test.toString();
        return link.startsWith("http://") || link.startsWith("https://");
    }
}

