/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.jasig.portlet.announcements.spring.PortletApplicationContextLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextConnectionProvider
implements ConnectionProvider {
    private static final String DATA_SOURCE_BEAN_NAME = "dataSource";
    private ApplicationContext context;
    private final Logger logger = Logger.getLogger(this.getClass());

    public void close() throws HibernateException {
        if (this.context != null) {
            ((ConfigurableApplicationContext)this.context).close();
        }
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
    }

    public Connection getConnection() throws SQLException {
        if (this.context == null) {
            this.init();
        }
        DataSource dataSource = (DataSource)this.context.getBean(DATA_SOURCE_BEAN_NAME, DataSource.class);
        Connection rslt = dataSource.getConnection();
        this.logger.info((Object)("Providing the following connection to hbm2ddl:  " + rslt));
        return rslt;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    private synchronized void init() {
        if (this.context != null) {
            return;
        }
        try {
            this.context = PortletApplicationContextLocator.getApplicationContext("classpath:/context/databaseContext.xml");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to load the application context from classpath:/context/databaseContext.xml", (Throwable)e);
        }
    }
}

