/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.servlet;

import java.util.Date;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="ajaxApproveController")
public class AjaxApproveController {
    private static final int STATUS_SCHEDULED = 0;
    private static final int STATUS_EXPIRED = 1;
    private static final int STATUS_SHOWING = 2;
    private static final int STATUS_PENDING = 3;
    private IAnnouncementService announcementService;
    private EhCacheCacheManager cacheManager = null;

    @Autowired
    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    @Autowired
    public void setCacheManager(EhCacheCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @RequestMapping
    public ModelAndView toggleApprove(HttpServletRequest request) throws PortletException {
        Long annId = Long.valueOf(request.getParameter("annId"));
        Boolean approval = Boolean.valueOf(request.getParameter("approval"));
        Announcement ann = this.announcementService.getAnnouncement(annId);
        Date startDisplay = ann.getStartDisplay();
        Date endDisplay = ann.getEndDisplay();
        if (endDisplay == null) {
            long aYearFromNow = System.currentTimeMillis() + 31536000000L;
            endDisplay = new Date(aYearFromNow);
        }
        Date now = new Date();
        int status = 3;
        if (startDisplay.after(now) && endDisplay.after(now) && approval.booleanValue()) {
            status = 0;
        } else if (startDisplay.before(now) && endDisplay.after(now) && approval.booleanValue()) {
            status = 2;
        } else if (endDisplay.before(now)) {
            status = 1;
        }
        ann.setPublished(approval);
        this.cacheManager.getCacheManager().getCache("guestAnnouncementCache").flush();
        this.announcementService.addOrSaveAnnouncement(ann);
        return new ModelAndView("ajaxApprove", "status", (Object)status);
    }
}

