/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.portlet.display;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.xml.namespace.QName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.AnnouncementSortStrategy;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.mvc.IViewNameSelector;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserIdService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.jasig.portlet.announcements.service.UserPermissionCheckerFactory;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationQuery;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AnnouncementsViewController
implements InitializingBean {
    public static final String ACTION_DISPLAY_FULL_ANNOUNCEMENT = "displayFullAnnouncement";
    public static final String PREFERENCE_DISPLAY_STARTDATE = "AnnouncementsViewController.displayPublishDate";
    public static final String PREFERENCE_DISABLE_EDIT = "AnnouncementsViewController.PREFERENCE_DISABLE_EDIT";
    public static final String PREFERENCE_PAGE_SIZE = "AnnouncementsViewController.PAGE_SIZE";
    public static final String PREFERENCE_SORT_STRATEGY = "AnnouncementsViewController.AnnouncementSortStrategy";
    public static final String PREFERENCE_USE_SCROLLING_DISPLAY = "AnnouncementsViewController.useScrollingDisplay";
    public static final String PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS = "AnnouncementsViewController.scrollingDisplayHeightPixels";
    public static final String PREFERENCE_HIDE_ABSTRACT = "AnnouncementsViewController.hideAbstract";
    public static final String PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS = "AnnouncementsViewController.syndicateTopicsAsNotifications";
    public static final String PREFERENCE_SYNDICATE_TOPICS_ANNOUNCEMENTS_DISPLAY_FNAME = "AnnouncementsViewController.syndicateTopicsAnnouncementsDisplayFName";
    public static final String DEFAULT_SORT_STRATEGY = "START_DISPLAY_DATE_ASCENDING";
    public static final String NOTIFICATION_NAMESPACE = "https://source.jasig.org/schemas/portlet/notification";
    public static final String NOTIFICATION_QUERY_LOCAL_NAME = "NotificationQuery";
    public static final QName NOTIFICATION_QUERY_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationQuery");
    public static final String NOTIFICATION_QUERY_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationQuery";
    public static final String NOTIFICATION_RESULT_LOCAL_NAME = "NotificationResult";
    public static final QName NOTIFICATION_RESULT_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationResult");
    public static final String NOTIFICATION_RESULT_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationResult";
    @Autowired
    private ITopicSubscriptionService tss = null;
    @Autowired
    private final IAnnouncementService announcementService = null;
    @Autowired
    private EhCacheCacheManager cm = null;
    @Autowired(required=true)
    private IViewNameSelector viewNameSelector;
    @Autowired
    private UserPermissionCheckerFactory userPermissionCheckerFactory;
    @Autowired
    private UserIdService userIdService;
    private Cache guestAnnouncementCache = null;
    private final Logger logger = Logger.getLogger(this.getClass());

    @RenderMapping
    public String mainView(Model model, RenderRequest request, @RequestParam(value="from", required=false) Integer from, @RequestParam(value="to", required=false) Integer to) throws PortletException {
        List<Announcement> emergencyAnnouncements;
        ArrayList<Announcement> announcements;
        if (from == null || to == null) {
            from = 0;
            to = (Integer)model.asMap().get("increment");
        }
        PortletPreferences prefs = request.getPreferences();
        String userId = this.userIdService.getUserId((PortletRequest)request);
        Element guestCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)userId));
        Element emergCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)"emergency"));
        Boolean isGuest = (Boolean)model.asMap().get("isGuest");
        if (!isGuest.booleanValue() || guestCacheElement == null || emergCacheElement == null) {
            announcements = new ArrayList();
            emergencyAnnouncements = new ArrayList();
            List<TopicSubscription> myTopics = this.tss.getTopicSubscription((PortletRequest)request);
            for (TopicSubscription ts : myTopics) {
                if (ts.getSubscribed().booleanValue() && ts.getTopic().getSubscriptionMethod() != 4) {
                    announcements.addAll(ts.getTopic().getPublishedAnnouncements());
                    continue;
                }
                if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() != 4) continue;
                emergencyAnnouncements.addAll(ts.getTopic().getPublishedAnnouncements());
            }
            Comparator<Announcement> sortStrategy = AnnouncementSortStrategy.getStrategy(prefs.getValue(PREFERENCE_SORT_STRATEGY, DEFAULT_SORT_STRATEGY));
            Collections.sort(announcements, sortStrategy);
            Collections.sort(emergencyAnnouncements, sortStrategy);
            if (isGuest.booleanValue()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Guest cache expired. Regenerating guest cache.");
                }
                this.guestAnnouncementCache.put(new Element((Object)userId, announcements));
                this.guestAnnouncementCache.put(new Element((Object)"emergency", emergencyAnnouncements));
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Guest cache valid. Using guest cache.");
            }
            announcements = (List)guestCacheElement.getObjectValue();
            emergencyAnnouncements = (List)emergCacheElement.getObjectValue();
        }
        Boolean useScrollingDisplay = (Boolean)model.asMap().get("useScrollingDisplay");
        ArrayList<Announcement> announcementsShort = useScrollingDisplay != false ? announcements : this.paginateAnnouncements(announcements, from, to, model);
        Boolean disableEdit = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_EDIT, "false"));
        model.addAttribute("disableEdit", (Object)disableEdit);
        model.addAttribute("from", (Object)new Integer(from));
        model.addAttribute("to", (Object)new Integer(to));
        model.addAttribute("hasMore", (Object)(useScrollingDisplay == false && announcements.size() > to ? 1 : 0));
        model.addAttribute("announcements", announcementsShort);
        model.addAttribute("emergency", emergencyAnnouncements);
        model.addAttribute("hideAbstract", (Object)Boolean.valueOf(prefs.getValue(PREFERENCE_HIDE_ABSTRACT, "false")));
        return this.viewNameSelector.select((PortletRequest)request, "displayAnnouncements");
    }

    @RenderMapping(params={"action=displayFullAnnouncement"})
    public String displayFullAnnouncement(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, ACTION_DISPLAY_FULL_ANNOUNCEMENT);
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationQuery")
    public void syndicateAnnouncementsAsNotifications(EventRequest req, EventResponse res) throws PortletException {
        NotificationQuery query = (NotificationQuery)req.getEvent().getValue();
        this.logger.debug((Object)("Syndicating announcements for Notification portlet with windowId=" + query.getQueryWindowId()));
        PortletPreferences prefs = req.getPreferences();
        List<String> topicTitlesToSyndicate = Arrays.asList(prefs.getValues(PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS, new String[0]));
        if (topicTitlesToSyndicate.isEmpty()) {
            this.logger.debug((Object)"No topics are defined for syndication with the Notification portlet");
            return;
        }
        String announcementsDisplayFName = prefs.getValue(PREFERENCE_SYNDICATE_TOPICS_ANNOUNCEMENTS_DISPLAY_FNAME, "announcements");
        this.logger.debug((Object)("Using announcementsDisplayFName=" + announcementsDisplayFName));
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        List<TopicSubscription> myTopics = this.tss.getTopicSubscription((PortletRequest)req);
        for (TopicSubscription topicSub : myTopics) {
            Topic topic = topicSub.getTopic();
            if (!topicTitlesToSyndicate.contains(topic.getTitle())) continue;
            this.logger.debug((Object)("Considering topic '" + topic.getTitle() + "' for remoteUser=" + req.getRemoteUser()));
            Set<Announcement> announcements = topic.getPublishedAnnouncements();
            if (announcements.isEmpty()) continue;
            ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>();
            for (Announcement ann : announcements) {
                NotificationEntry entry = new NotificationEntry();
                entry.setTitle(ann.getTitle());
                entry.setBody(ann.getAbstractText());
                entry.setSource("Announcements");
                StringBuilder url = new StringBuilder();
                url.append("/uPortal").append("/p/").append(announcementsDisplayFName).append("/max/render.uP?pP_action=displayFullAnnouncement&pP_announcementId=").append(ann.getId());
                entry.setUrl(url.toString());
                entries.add(entry);
            }
            NotificationCategory category = new NotificationCategory();
            category.setTitle(topic.getTitle());
            category.setEntries(entries);
            categories.add(category);
        }
        this.logger.debug((Object)("Found the following categories for remoteUser '" + req.getRemoteUser() + "':  " + categories));
        if (categories.isEmpty()) {
            return;
        }
        NotificationResponse response = new NotificationResponse();
        response.setCategories(categories);
        NotificationResult result = new NotificationResult();
        result.setQueryWindowId(query.getQueryWindowId());
        result.setResultWindowId(req.getWindowID());
        result.setNotificationResponse(response);
        res.setEvent(NOTIFICATION_RESULT_QNAME, (Serializable)result);
    }

    @ModelAttribute(value="displayPublishDate")
    public boolean getDisplayPublishDate(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.parseBoolean(prefs.getValue(PREFERENCE_DISPLAY_STARTDATE, "false"));
    }

    public void setTss(ITopicSubscriptionService tss) {
        this.tss = tss;
    }

    public void afterPropertiesSet() throws Exception {
        this.guestAnnouncementCache = this.cm.getCacheManager().getCache("guestAnnouncementCache");
        if (this.guestAnnouncementCache == null) {
            throw new BeanCreationException("Required guestAnnouncementCache could not be loaded.");
        }
        this.logger.debug((Object)"guestAnnouncementCache created.");
    }

    public void setCm(EhCacheCacheManager cm) {
        this.cm = cm;
    }

    @RenderMapping(params={"action=displayFullAnnouncementHistory"})
    public String displayFullAnnouncementHistory(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, "displayFullAnnouncementHistory");
    }

    @RenderMapping(params={"action=displayHistory"})
    public String displayHistory(Model model, RenderRequest request) throws Exception {
        ArrayList<Announcement> announcements = new ArrayList<Announcement>();
        List<TopicSubscription> myTopics = this.tss.getTopicSubscription((PortletRequest)request);
        for (TopicSubscription ts : myTopics) {
            if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() == 4) continue;
            announcements.addAll(ts.getTopic().getHistoricAnnouncements());
        }
        Collections.sort(announcements, new Comparator<Announcement>(){

            @Override
            public int compare(Announcement s, Announcement s2) {
                return s2.getEndDisplay().compareTo(s.getEndDisplay());
            }
        });
        model.addAttribute("announcements", announcements);
        return this.viewNameSelector.select((PortletRequest)request, "displayHistory");
    }

    @ModelAttribute(value="increment")
    public int getPageSize(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 5;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_PAGE_SIZE, "5"));
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.PAGE_SIZE: " + prefs.getValue(PREFERENCE_PAGE_SIZE, null)));
        }
        return rslt;
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        boolean rslt = req.getRemoteUser() == null;
        this.logger.debug((Object)("isGuest is: " + Boolean.toString(rslt)));
        this.logger.debug((Object)("remoteUser is: " + req.getRemoteUser()));
        return rslt;
    }

    @ModelAttribute(value="useScrollingDisplay")
    public boolean getUseScrollingDisplay(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.valueOf(prefs.getValue(PREFERENCE_USE_SCROLLING_DISPLAY, "false"));
    }

    @ModelAttribute(value="scrollingDisplayHeightPixels")
    public int getScrollingDisplayHeightPixels(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 500;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, "500"));
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.scrollingDisplayHeightPixels: " + prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, null)));
        }
        return rslt;
    }

    private List<Announcement> paginateAnnouncements(List<Announcement> announcements, Integer from, Integer to, Model model) {
        List<Announcement> rslt;
        if (announcements.size() < to - from) {
            rslt = announcements;
        } else {
            rslt = new ArrayList<Announcement>();
            for (int i = from.intValue(); i < to && announcements.size() > i; ++i) {
                if (announcements.get(i) == null) continue;
                rslt.add(announcements.get(i));
            }
        }
        return rslt;
    }

    private Announcement getAnnouncementById(PortletRequest request, String announcementId) throws Exception {
        Long annId = Long.valueOf(announcementId);
        Announcement announcement = this.announcementService.getAnnouncement(annId);
        if (!UserPermissionChecker.inRoleForTopic(request, "audience", announcement.getParent())) {
            throw new UnauthorizedException();
        }
        return announcement;
    }
}

