/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.model.AnnouncementConfiguration;
import org.jasig.portlet.announcements.model.AnnouncementFilterType;
import org.jasig.portlet.announcements.service.AnnouncementPreferences;
import org.jasig.portlet.announcements.service.IConfigService;
import org.springframework.stereotype.Service;

@Service
public class ConfigService
implements IConfigService {
    public AnnouncementConfiguration getConfiguration(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        AnnouncementConfiguration config = new AnnouncementConfiguration();
        config.setFilterType(prefs.getValue(AnnouncementPreferences.FILTER_TYPE.getKey(), AnnouncementFilterType.BLACKLIST.getKey()));
        config.setFilterItems(prefs.getValues(AnnouncementPreferences.FILTER_ITEMS.getKey(), new String[0]));
        return config;
    }

    public void saveConfiguration(ActionRequest request, AnnouncementConfiguration config) {
        PortletPreferences prefs = request.getPreferences();
        try {
            prefs.setValue(AnnouncementPreferences.FILTER_TYPE.getKey(), config.getFilterType());
            prefs.setValues(AnnouncementPreferences.FILTER_ITEMS.getKey(), config.getFilterItems().toArray(new String[0]));
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to store configuration", e);
        }
    }
}

