/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.jasig.portlet.announcements.model.Role;
import org.jasig.portlet.announcements.service.IGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userIdService")
public class UserIdService {
    private static final String GUEST_USER_ID_PREFIX = "g_";
    private static final String ROLE_NAME_NONE = "NONE";
    @Autowired
    private IGroupService groupService;
    private MessageDigest md5;

    @PostConstruct
    public void init() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Failed to create the MD5 MessageDigest";
            throw new RuntimeException("Failed to create the MD5 MessageDigest", e);
        }
    }

    public String getUserId(PortletRequest req) {
        String rslt = req.getRemoteUser() != null ? req.getRemoteUser() : this.calculateGuestUserIdHash(req);
        return rslt;
    }

    private String calculateGuestUserIdHash(PortletRequest req) {
        StringBuilder rolesString = new StringBuilder();
        List allRoles = this.groupService.getAllRoles();
        ArrayList<String> userRoleNames = new ArrayList<String>();
        for (Role r : allRoles) {
            String roleName = r.getName();
            if (!req.isUserInRole(roleName)) continue;
            userRoleNames.add(roleName);
        }
        if (userRoleNames.size() != 0) {
            Collections.sort(userRoleNames);
            for (String s : userRoleNames) {
                if (rolesString.length() != 0) {
                    rolesString.append("-");
                }
                rolesString.append(s);
            }
        } else {
            rolesString.append(ROLE_NAME_NONE);
        }
        byte[] digest = this.md5.digest(rolesString.toString().getBytes());
        String hex = DigestUtils.md2Hex((byte[])digest);
        return GUEST_USER_ID_PREFIX + hex;
    }
}

