/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.UserRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserPermissionChecker
implements UserRoles {
    private static final String GUEST_USERNAME = "guest";
    private static final String USERNAME_PREFIX = "USER.";
    private final boolean admin;
    private final boolean moderator;
    private final boolean author;
    private final boolean audience;
    private final String userName;
    private final boolean guest;
    private static final Logger logger = LoggerFactory.getLogger(UserPermissionChecker.class);

    UserPermissionChecker(PortletRequest request, Topic topic) {
        this.guest = request.getRemoteUser() == null;
        String string = this.userName = this.guest ? GUEST_USERNAME : request.getRemoteUser();
        if (request.isUserInRole("Portal_Administrators") || UserPermissionChecker.inRoleForTopic(request, "admin", topic)) {
            this.author = true;
            this.moderator = true;
            this.admin = true;
        } else if (UserPermissionChecker.inRoleForTopic(request, "moderator", topic)) {
            this.admin = false;
            this.author = true;
            this.moderator = true;
        } else if (UserPermissionChecker.inRoleForTopic(request, "author", topic)) {
            this.moderator = false;
            this.admin = false;
            this.author = true;
        } else {
            this.author = false;
            this.moderator = false;
            this.admin = false;
        }
        this.audience = UserPermissionChecker.inRoleForTopic(request, "audience", topic);
    }

    public static boolean inRoleForTopic(PortletRequest request, String role, Topic topic) {
        boolean isGuest;
        boolean bl = isGuest = request.getRemoteUser() == null;
        if (!isGuest && UserPermissionChecker.isPortalAdmin(request)) {
            return true;
        }
        String userName = isGuest ? GUEST_USERNAME : request.getRemoteUser();
        Set<String> group = topic.getGroup(role);
        for (String groupMember : group) {
            if (groupMember.startsWith(USERNAME_PREFIX)) {
                String[] p = groupMember.split("\\.");
                if (p.length == 1) {
                    logger.warn("BAD DATA:  Role '{}' for Topic '{}' contains a username prefix ('USER.') without a username;  ignoring this value.", (Object)role, (Object)topic.getTitle());
                    continue;
                }
                if (!p[1].equalsIgnoreCase(userName)) continue;
                return true;
            }
            if (!request.isUserInRole(groupMember)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortalAdmin(PortletRequest request) {
        return request.isUserInRole("Portal_Administrators");
    }

    public boolean isGuest() {
        return this.guest;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public boolean isAudience() {
        return this.audience;
    }

    public boolean canEditTopic() {
        return this.isAuthor() || this.isModerator() || this.isAdmin();
    }

    public void validateCanEditTopic() {
        if (!this.canEditTopic()) {
            throw new UnauthorizedException("You do not have access to this topic!");
        }
    }
}

