/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.spring.PortletApplicationContextLocator;
import org.jasig.portlet.announcements.spring.SingletonDoubleCheckedCreator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletApplicationContextLocator
implements ServletContextListener {
    public static final String DATABASE_CONTEXT_LOCATION = "classpath:/context/databaseContext.xml";
    private static final SingletonDoubleCheckedCreator<ConfigurableApplicationContext> applicationContextCreator = new PortletApplicationContextCreator(null);
    private static Throwable directCreatorThrowable;
    private static ServletContext servletContext;
    private static Log LOGGER;

    public void contextInitialized(ServletContextEvent sce) {
        servletContext = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        servletContext = null;
    }

    @Deprecated
    public static boolean isRunningInWebApplication() {
        return servletContext != null;
    }

    @Deprecated
    public static WebApplicationContext getRequiredWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            throw new IllegalStateException("No ServletContext is available to load a WebApplicationContext for. Is this ServletContextListener not configured or has the ServletContext been destroyed?");
        }
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
    }

    @Deprecated
    public static WebApplicationContext getWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            return null;
        }
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
    }

    public static ApplicationContext getApplicationContext(String importExportContextFile) {
        ServletContext context = servletContext;
        if (context != null) {
            LOGGER.debug((Object)"Using WebApplicationContext");
            if (applicationContextCreator.isCreated()) {
                IllegalStateException createException = new IllegalStateException("A portal managed ApplicationContext has already been created but now a ServletContext is available and a WebApplicationContext will be returned. This situation should be resolved by delaying calls to this class until after the web-application has completely initialized.");
                LOGGER.error((Object)createException, (Throwable)createException);
                LOGGER.error((Object)"Stack trace of original ApplicationContext creator", directCreatorThrowable);
                throw createException;
            }
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            if (webApplicationContext == null) {
                throw new IllegalStateException("ServletContext is available but WebApplicationContextUtils.getWebApplicationContext(ServletContext) returned null. Either the application context failed to load or is not yet done loading.");
            }
            return webApplicationContext;
        }
        return (ApplicationContext)applicationContextCreator.get(new Object[]{importExportContextFile});
    }

    public static void shutdown() {
        if (applicationContextCreator.isCreated()) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)applicationContextCreator.get(new Object[0]);
            applicationContext.close();
        } else {
            IllegalStateException createException = new IllegalStateException("No portal managed ApplicationContext has been created, there is nothing to shutdown.");
            LOGGER.error((Object)createException, (Throwable)createException);
        }
    }

    static /* synthetic */ Log access$100() {
        return LOGGER;
    }

    static /* synthetic */ Throwable access$202(Throwable x0) {
        directCreatorThrowable = x0;
        return directCreatorThrowable;
    }

    static /* synthetic */ Throwable access$200() {
        return directCreatorThrowable;
    }

    static {
        LOGGER = LogFactory.getLog(PortletApplicationContextLocator.class);
    }
}

