/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.portlet.display;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.AnnouncementSortStrategy;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.mvc.IViewNameSelector;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserIdService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.jasig.portlet.announcements.service.UserPermissionCheckerFactory;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationQuery;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AnnouncementsViewController {
    public static final String ACTION_DISPLAY_FULL_ANNOUNCEMENT = "displayFullAnnouncement";
    public static final String PREFERENCE_DISPLAY_STARTDATE = "AnnouncementsViewController.displayPublishDate";
    public static final String PREFERENCE_DISABLE_EDIT = "AnnouncementsViewController.PREFERENCE_DISABLE_EDIT";
    public static final String PREFERENCE_PAGE_SIZE = "AnnouncementsViewController.PAGE_SIZE";
    public static final String PREFERENCE_SORT_STRATEGY = "AnnouncementsViewController.AnnouncementSortStrategy";
    public static final String PREFERENCE_USE_SCROLLING_DISPLAY = "AnnouncementsViewController.useScrollingDisplay";
    public static final String PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS = "AnnouncementsViewController.scrollingDisplayHeightPixels";
    public static final String PREFERENCE_HIDE_ABSTRACT = "AnnouncementsViewController.hideAbstract";
    public static final String PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS = "AnnouncementsViewController.syndicateTopicsAsNotifications";
    public static final String PREFERENCE_SYNDICATE_TOPICS_ANNOUNCEMENTS_DISPLAY_FNAME = "AnnouncementsViewController.syndicateTopicsAnnouncementsDisplayFName";
    public static final String DEFAULT_SORT_STRATEGY = "START_DISPLAY_DATE_ASCENDING";
    public static final String NOTIFICATION_NAMESPACE = "https://source.jasig.org/schemas/portlet/notification";
    public static final String NOTIFICATION_QUERY_LOCAL_NAME = "NotificationQuery";
    public static final QName NOTIFICATION_QUERY_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationQuery");
    public static final String NOTIFICATION_QUERY_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationQuery";
    public static final String NOTIFICATION_RESULT_LOCAL_NAME = "NotificationResult";
    public static final QName NOTIFICATION_RESULT_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationResult");
    public static final String NOTIFICATION_RESULT_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationResult";
    @Autowired
    private final IAnnouncementService announcementService = null;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ITopicSubscriptionService tss = null;
    @Autowired
    private EhCacheCacheManager cm = null;
    @Autowired(required=true)
    private IViewNameSelector viewNameSelector;
    @Autowired
    private UserPermissionCheckerFactory userPermissionCheckerFactory;
    @Autowired
    private UserIdService userIdService;

    @RenderMapping
    public String mainView(Model model, RenderRequest request, @RequestParam(value="from", required=false) Integer from, @RequestParam(value="to", required=false) Integer to) throws PortletException {
        if (from == null || to == null) {
            from = 0;
            to = (Integer)model.asMap().get("increment");
        }
        PortletPreferences prefs = request.getPreferences();
        List[] lists = this.getLists((PortletRequest)request);
        List<Announcement> announcements = lists[0];
        List emergencyAnnouncements = lists[1];
        Comparator<Announcement> sortStrategy = AnnouncementSortStrategy.getStrategy(prefs.getValue(PREFERENCE_SORT_STRATEGY, DEFAULT_SORT_STRATEGY));
        Collections.sort(announcements, sortStrategy);
        Collections.sort(emergencyAnnouncements, sortStrategy);
        Boolean useScrollingDisplay = (Boolean)model.asMap().get("useScrollingDisplay");
        List<Announcement> announcementsShort = useScrollingDisplay != false ? announcements : this.paginateAnnouncements(announcements, from, to, model);
        Boolean disableEdit = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_EDIT, "false"));
        model.addAttribute("disableEdit", (Object)disableEdit);
        model.addAttribute("from", (Object)new Integer(from));
        model.addAttribute("to", (Object)new Integer(to));
        model.addAttribute("hasMore", (Object)(useScrollingDisplay == false && announcements.size() > to ? 1 : 0));
        model.addAttribute("announcements", announcementsShort);
        model.addAttribute("emergency", (Object)emergencyAnnouncements);
        model.addAttribute("hideAbstract", (Object)Boolean.valueOf(prefs.getValue(PREFERENCE_HIDE_ABSTRACT, "false")));
        return this.viewNameSelector.select((PortletRequest)request, "displayAnnouncements");
    }

    private List[] getLists(PortletRequest request) throws PortletException {
        String userId = this.userIdService.getUserId(request);
        List<TopicSubscription> myTopics = this.tss.getTopicSubscription(request);
        Map<Boolean, List<Announcement>> topicLists = myTopics.stream().filter(TopicSubscription::getSubscribed).map(ts -> ts.getTopic().getPublishedAnnouncements()).flatMap(x -> x.stream()).collect(Collectors.partitioningBy(a -> a.getParent().getSubscriptionMethod() == 4));
        return new List[]{topicLists.get(false), topicLists.get(true)};
    }

    @ResourceMapping(value="emergencies")
    public void emergenciesResource(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        this.logger.debug((Object)"Processing AJAX resource request for emergency alerts");
        List[] lists = this.getLists((PortletRequest)request);
        String json = this.mapper.writeValueAsString((Object)lists[1]);
        response.getWriter().write(json != null && !json.isEmpty() ? json : "[]");
    }

    @ResourceMapping(value="announcements")
    public void announcementsResource(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        this.logger.debug((Object)"Processing AJAX resource request for announcements");
        List[] lists = this.getLists((PortletRequest)request);
        String json = this.mapper.writeValueAsString((Object)lists[0]);
        response.getWriter().write(json != null && !json.isEmpty() ? json : "[]");
    }

    @RenderMapping(params={"action=displayFullAnnouncement"})
    public String displayFullAnnouncement(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, ACTION_DISPLAY_FULL_ANNOUNCEMENT);
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationQuery")
    public void syndicateAnnouncementsAsNotifications(EventRequest req, EventResponse res) throws PortletException {
        NotificationQuery query = (NotificationQuery)req.getEvent().getValue();
        this.logger.debug((Object)("Syndicating announcements for Notification portlet with windowId=" + query.getQueryWindowId()));
        PortletPreferences prefs = req.getPreferences();
        List<String> topicTitlesToSyndicate = Arrays.asList(prefs.getValues(PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS, new String[0]));
        if (topicTitlesToSyndicate.isEmpty()) {
            this.logger.debug((Object)"No topics are defined for syndication with the Notification portlet");
            return;
        }
        String announcementsDisplayFName = prefs.getValue(PREFERENCE_SYNDICATE_TOPICS_ANNOUNCEMENTS_DISPLAY_FNAME, "announcements");
        this.logger.debug((Object)("Using announcementsDisplayFName=" + announcementsDisplayFName));
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        List<TopicSubscription> myTopics = this.tss.getTopicSubscription((PortletRequest)req);
        for (TopicSubscription topicSub : myTopics) {
            Topic topic = topicSub.getTopic();
            if (!topicTitlesToSyndicate.contains(topic.getTitle())) continue;
            this.logger.debug((Object)("Considering topic '" + topic.getTitle() + "' for remoteUser=" + req.getRemoteUser()));
            Set<Announcement> announcements = topic.getPublishedAnnouncements();
            if (announcements.isEmpty()) continue;
            ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>();
            for (Announcement ann : announcements) {
                NotificationEntry entry = new NotificationEntry();
                entry.setTitle(ann.getTitle());
                entry.setBody(ann.getAbstractText());
                entry.setSource("Announcements");
                StringBuilder url = new StringBuilder();
                url.append("/uPortal").append("/p/").append(announcementsDisplayFName).append("/max/render.uP?pP_action=displayFullAnnouncement&pP_announcementId=").append(ann.getId());
                entry.setUrl(url.toString());
                entries.add(entry);
            }
            NotificationCategory category = new NotificationCategory();
            category.setTitle(topic.getTitle());
            category.setEntries(entries);
            categories.add(category);
        }
        this.logger.debug((Object)("Found the following categories for remoteUser '" + req.getRemoteUser() + "':  " + categories));
        if (categories.isEmpty()) {
            return;
        }
        NotificationResponse response = new NotificationResponse();
        response.setCategories(categories);
        NotificationResult result = new NotificationResult();
        result.setQueryWindowId(query.getQueryWindowId());
        result.setResultWindowId(req.getWindowID());
        result.setNotificationResponse(response);
        res.setEvent(NOTIFICATION_RESULT_QNAME, (Serializable)result);
    }

    @ModelAttribute(value="displayPublishDate")
    public boolean getDisplayPublishDate(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.parseBoolean(prefs.getValue(PREFERENCE_DISPLAY_STARTDATE, "false"));
    }

    public void setTss(ITopicSubscriptionService tss) {
        this.tss = tss;
    }

    public void setCm(EhCacheCacheManager cm) {
        this.cm = cm;
    }

    @RenderMapping(params={"action=displayFullAnnouncementHistory"})
    public String displayFullAnnouncementHistory(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, "displayFullAnnouncementHistory");
    }

    @RenderMapping(params={"action=displayHistory"})
    public String displayHistory(Model model, RenderRequest request) throws Exception {
        ArrayList<Announcement> announcements = new ArrayList<Announcement>();
        List<TopicSubscription> myTopics = this.tss.getTopicSubscription((PortletRequest)request);
        for (TopicSubscription ts : myTopics) {
            if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() == 4) continue;
            announcements.addAll(ts.getTopic().getHistoricAnnouncements());
        }
        Collections.sort(announcements, new Comparator<Announcement>(){

            @Override
            public int compare(Announcement s, Announcement s2) {
                return s2.getEndDisplay().compareTo(s.getEndDisplay());
            }
        });
        model.addAttribute("announcements", announcements);
        return this.viewNameSelector.select((PortletRequest)request, "displayHistory");
    }

    @ModelAttribute(value="increment")
    public int getPageSize(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 5;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_PAGE_SIZE, "5"));
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.PAGE_SIZE: " + prefs.getValue(PREFERENCE_PAGE_SIZE, null)));
        }
        return rslt;
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        boolean rslt = req.getRemoteUser() == null;
        this.logger.debug((Object)("isGuest is: " + Boolean.toString(rslt)));
        this.logger.debug((Object)("remoteUser is: " + req.getRemoteUser()));
        return rslt;
    }

    @ModelAttribute(value="useScrollingDisplay")
    public boolean getUseScrollingDisplay(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.valueOf(prefs.getValue(PREFERENCE_USE_SCROLLING_DISPLAY, "false"));
    }

    @ModelAttribute(value="scrollingDisplayHeightPixels")
    public int getScrollingDisplayHeightPixels(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 500;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, "500"));
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.scrollingDisplayHeightPixels: " + prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, null)));
        }
        return rslt;
    }

    private List<Announcement> paginateAnnouncements(List<Announcement> announcements, Integer from, Integer to, Model model) {
        List<Announcement> rslt;
        if (announcements.size() < to - from) {
            rslt = announcements;
        } else {
            rslt = new ArrayList<Announcement>();
            for (int i = from.intValue(); i < to && announcements.size() > i; ++i) {
                if (announcements.get(i) == null) continue;
                rslt.add(announcements.get(i));
            }
        }
        return rslt;
    }

    private Announcement getAnnouncementById(PortletRequest request, String announcementId) throws Exception {
        Long annId = Long.valueOf(announcementId);
        Announcement announcement = this.announcementService.getAnnouncement(annId);
        if (!UserPermissionChecker.inRoleForTopic(request, "audience", announcement.getParent())) {
            throw new UnauthorizedException();
        }
        return announcement;
    }
}

