/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.portlet.display;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.AnnouncementConfiguration;
import org.jasig.portlet.announcements.service.IConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"CONFIG"})
public class AnnouncementConfigurationController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IConfigService configService;

    @Autowired(required=true)
    public void setConfigService(IConfigService configService) {
        this.configService = configService;
    }

    @RequestMapping
    public String getConfigFormView() {
        return "config";
    }

    @RequestMapping(params={"action=updateConfiguration"})
    public void saveConfiguration(ActionRequest request, ActionResponse response, @ModelAttribute(value="config") AnnouncementConfiguration config, @RequestParam(value="save", required=false) String save) throws PortletModeException {
        if (StringUtils.isNotBlank((String)save)) {
            this.log.debug((Object)("Saving announcement configuration: {" + config.toString() + "}"));
            this.configService.saveConfiguration(request, config);
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="config")
    public AnnouncementConfiguration announcementConfiguration(PortletRequest request) {
        AnnouncementConfiguration config = this.configService.getConfiguration(request);
        return config;
    }
}

