/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.servlet;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEnclosureImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import javax.portlet.PortletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="rssFeedController")
public class RssFeedController {
    private static final String CONTENT_TYPE = "application/rss+xml";
    private static final String ANNOUNCEMENT_DEEP_LINK_FORMAT = "%s/%s/p/%s?pP_announcementId=%d&pP_action=displayFullAnnouncement";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String FILENAME_ATTRIBUTE = "filename";
    private IAnnouncementService announcementService;
    @Value(value="${RssFeedController.portalContextName:uPortal}")
    private String portalContextName;
    @Value(value="${RssFeedController.announcementsPortletFname:announcements}")
    private String announcementsPortletFname;
    private ObjectMapper objectMapper = new ObjectMapper();
    private final MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
    private final Log logger = LogFactory.getLog(this.getClass());

    @Autowired
    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    @RequestMapping(produces={"application/rss+xml"})
    public void getRssFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String out;
        Topic topic;
        try {
            topic = this.selectTopic(request);
        }
        catch (IllegalArgumentException | ServletRequestBindingException e) {
            response.sendError(400, "Must specify a valid 'topic' (id) or 'topicTitle' parameter");
            this.logger.info((Object)"Returning SC_BAD_REQUEST because topic (id) and/or topicTitle were improperly specified in the request", e);
            return;
        }
        if (topic == null) {
            response.sendError(404, "No such topic");
            return;
        }
        if (!topic.isAllowRss()) {
            response.sendError(403, "This topic is not available as RSS");
            return;
        }
        SyndFeed feed = this.buildRssFeed(topic, request);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            out = output.outputString(feed);
        }
        catch (FeedException e) {
            this.logger.warn((Object)String.format("Failed to create SyndFeedOutput for topic '%s'", topic.getTitle()));
            response.sendError(500, "Error generating feed");
            return;
        }
        response.setContentLength(out.length());
        response.getOutputStream().print(out);
        response.getOutputStream().flush();
    }

    private Topic selectTopic(HttpServletRequest req) throws ServletRequestBindingException {
        Topic rslt = null;
        Long topicId = ServletRequestUtils.getLongParameter((ServletRequest)req, (String)"topic");
        if (topicId != null) {
            try {
                rslt = this.announcementService.getTopic(topicId);
            }
            catch (PortletException pe) {
                this.logger.warn((Object)String.format("Failed to obtain a Topic for the specified id of '%s'", topicId));
            }
        } else {
            String titleParameter = ServletRequestUtils.getStringParameter((ServletRequest)req, (String)"topicTitle");
            if (titleParameter != null) {
                List<Topic> allTopics = this.announcementService.getAllTopics();
                for (Topic t : allTopics) {
                    String convertedTopicTitle = t.getTitle().trim().replaceAll("\\s", "-");
                    this.logger.debug((Object)String.format("Calculated convertedTopicTitle='%s' for topic with title='%s'", convertedTopicTitle, t.getTitle()));
                    if (!convertedTopicTitle.equalsIgnoreCase(titleParameter)) continue;
                    rslt = t;
                    break;
                }
                if (rslt != null) {
                    this.logger.debug((Object)String.format("Found topic '%s' for titleParameter='%s'", rslt.getTitle(), titleParameter));
                } else {
                    this.logger.warn((Object)String.format("Failed to obtain a Topic for the specified titleParameter of '%s'", titleParameter));
                }
            } else {
                throw new IllegalArgumentException("Neither 'topic' nor 'topicTitle' parameter specified");
            }
        }
        return rslt;
    }

    private SyndFeed buildRssFeed(Topic topic, HttpServletRequest request) throws IOException {
        String urlPrefix = this.calculateUrlPrefix(request);
        ArrayList<Announcement> announcements = new ArrayList<Announcement>(topic.getPublishedAnnouncements());
        Collections.sort(announcements);
        SyndFeedImpl rslt = new SyndFeedImpl();
        rslt.setFeedType("rss_2.0");
        rslt.setTitle(topic.getTitle());
        rslt.setLink(request.getRequestURL().append("?topic=").append(topic.getId()).toString());
        String feedDescription = String.format("RSS feed for " + topic.getTitle(), new Object[0]);
        if (!topic.getDescription().isEmpty()) {
            feedDescription = topic.getDescription();
        }
        rslt.setDescription(feedDescription);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (Announcement a : announcements) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(a.getTitle());
            entry.setAuthor(a.getAuthor());
            if (StringUtils.isNotBlank((String)a.getLink())) {
                entry.setLink(a.getLink());
            } else {
                String deepLink = String.format(ANNOUNCEMENT_DEEP_LINK_FORMAT, urlPrefix, this.portalContextName, this.announcementsPortletFname, a.getId());
                this.logger.debug((Object)String.format("Calculated the following deepLink for announcement with id=%s:  %s", a.getId(), deepLink));
                entry.setLink(deepLink);
            }
            entry.setPublishedDate(a.getStartDisplay());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(a.getAbstractText());
            entry.setDescription((SyndContent)description);
            Set<String> attachments = a.getAttachments();
            if (!attachments.isEmpty()) {
                ArrayList<SyndEnclosureImpl> enclosures = new ArrayList<SyndEnclosureImpl>();
                for (String attachment : attachments) {
                    JsonNode json = this.objectMapper.readTree(attachment);
                    SyndEnclosureImpl se = new SyndEnclosureImpl();
                    String enclosureUrl = urlPrefix + json.get(PATH_ATTRIBUTE).getTextValue();
                    se.setUrl(enclosureUrl);
                    se.setType(this.fileTypeMap.getContentType(json.get(FILENAME_ATTRIBUTE).getTextValue()));
                    enclosures.add(se);
                }
                entry.setEnclosures(enclosures);
            }
            entries.add(entry);
        }
        rslt.setEntries(entries);
        return rslt;
    }

    private String calculateUrlPrefix(HttpServletRequest req) {
        String requestUrl = req.getRequestURL().toString();
        String requestUri = req.getRequestURI();
        int urlPrefixLength = requestUrl.indexOf(requestUri);
        return requestUrl.substring(0, urlPrefixLength);
    }
}

