/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.model;

import java.util.Comparator;
import org.jasig.portlet.announcements.model.Announcement;

public enum AnnouncementSortStrategy {
    CREATE_DATE_ASCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    return ann1.getCreated().compareTo(ann2.getCreated());
                }
            };
        }
    }
    ,
    CREATE_DATE_DESCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    return CREATE_DATE_ASCENDING.getComparator().compare(ann1, ann2) * -1;
                }
            };
        }
    }
    ,
    START_DISPLAY_DATE_ASCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    return ann1.getStartDisplay().compareTo(ann2.getStartDisplay());
                }
            };
        }
    }
    ,
    START_DISPLAY_DATE_DESCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    return START_DISPLAY_DATE_ASCENDING.getComparator().compare(ann1, ann2) * -1;
                }
            };
        }
    }
    ,
    END_DISPLAY_DATE_ASCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    if (ann1.getEndDisplay() == null || ann2.getEndDisplay() == null) {
                        if (ann1.getEndDisplay() == null && ann2.getEndDisplay() == null) {
                            if (ann1.getTitle().equalsIgnoreCase(ann2.getTitle())) {
                                return ann1.getId().compareTo(ann2.getId());
                            }
                            return ann1.getTitle().compareTo(ann2.getTitle());
                        }
                        return ann1.getEndDisplay() == null ? 1 : -1;
                    }
                    return ann1.getEndDisplay().compareTo(ann2.getEndDisplay());
                }
            };
        }
    }
    ,
    END_DISPLAY_DATE_DESCENDING{

        @Override
        public Comparator<Announcement> getComparator() {
            return new Comparator<Announcement>(){

                @Override
                public int compare(Announcement ann1, Announcement ann2) {
                    return END_DISPLAY_DATE_ASCENDING.getComparator().compare(ann1, ann2) * -1;
                }
            };
        }
    }
    ,
    DEFAULT{

        @Override
        public Comparator<Announcement> getComparator() {
            return START_DISPLAY_DATE_DESCENDING.getComparator();
        }
    };


    public abstract Comparator<Announcement> getComparator();

    public static Comparator<Announcement> getStrategy(String strategyName) {
        AnnouncementSortStrategy strategy = AnnouncementSortStrategy.valueOf(strategyName);
        return strategy != null ? strategy.getComparator() : DEFAULT.getComparator();
    }
}

