/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.portlet.admin;

import java.util.Set;
import java.util.TreeSet;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import org.jasig.portlet.announcements.model.RoleSelection;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.IGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class AdminRoleSetController {
    @Autowired
    private IAnnouncementService announcementService;
    @Autowired
    private IGroupService groupService;

    @RequestMapping(params={"action=addMembers"})
    public void processSubmit(@ModelAttribute(value="selection") RoleSelection rolesSelected, BindingResult errors, @RequestParam(value="topicId") Long topicId, @RequestParam(value="groupKey") String groupKey, ActionResponse response) throws PortletException {
        if (!errors.hasErrors()) {
            Topic topic = this.announcementService.getTopic(topicId);
            Set<String> oldGroupList = topic.getGroup(groupKey);
            TreeSet<String> newList = new TreeSet<String>();
            for (String member : oldGroupList) {
                if (!member.startsWith("USER.")) continue;
                newList.add(member);
            }
            if (rolesSelected != null && rolesSelected.getSelectedRoles() != null && rolesSelected.getSelectedRoles().size() > 0) {
                newList.addAll(this.groupService.getSetForRoleSelection(rolesSelected));
            }
            topic.setGroup(groupKey, newList);
            this.announcementService.addOrSaveTopic(topic);
            response.setRenderParameter("topicId", topicId.toString());
            response.setRenderParameter("action", "showTopic");
        }
    }

    @RequestMapping(params={"action=addMembers"})
    public String showForm(@RequestParam(value="topicId") Long topicId, @RequestParam(value="groupKey") String groupKey, Model model) throws PortletException {
        if (!model.containsAttribute("selection")) {
            Topic topic = this.announcementService.getTopic(topicId);
            Set<String> group = topic.getGroup(groupKey);
            model.addAttribute("selection", (Object)new RoleSelection(group));
            model.addAttribute("roles", this.groupService.getAllRolesFromGroupSet(topic.getGroup(groupKey)));
            model.addAttribute((Object)topic);
        }
        model.addAttribute("groupKey", (Object)groupKey);
        return "addMembers";
    }

    @RequestMapping(params={"action=addUser"})
    public void processAddUser(ActionResponse response, @RequestParam(value="topicId") Long topicId, @RequestParam(value="groupKey") String groupKey, @RequestParam(value="userAdd") String userAdd) throws PortletException {
        Topic topic = this.announcementService.getTopic(topicId);
        Set<String> updateGroup = topic.getGroup(groupKey);
        updateGroup.add("USER." + userAdd);
        this.announcementService.addOrSaveTopic(topic);
        response.setRenderParameter("topicId", topicId.toString());
        response.setRenderParameter("groupKey", groupKey);
        response.setRenderParameter("action", "addMembers");
    }

    @RequestMapping(params={"action=deleteUser"})
    public void processDeleteUser(ActionResponse response, @RequestParam(value="topicId") Long topicId, @RequestParam(value="groupKey") String groupKey, @RequestParam(value="userKey") String userKey) throws PortletException {
        Topic topic = this.announcementService.getTopic(topicId);
        Set<String> updateGroup = topic.getGroup(groupKey);
        updateGroup.remove(userKey);
        this.announcementService.addOrSaveTopic(topic);
        response.setRenderParameter("topicId", topicId.toString());
        response.setRenderParameter("groupKey", groupKey);
        response.setRenderParameter("action", "addMembers");
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setGroupService(IGroupService groupService) {
        this.groupService = groupService;
    }
}

