/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.io.Serializable;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.UserIdService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.stereotype.Component;

@Component
public class UserPermissionCheckerFactory
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(UserPermissionCheckerFactory.class);
    private static final String CACHE_KEY_DELIM = "|";
    private static final String CACHE_NAME = "userPermissionCheckerCache";
    @Autowired
    private EhCacheCacheManager cacheManager = null;
    @Autowired
    private UserIdService userIdService;
    private Cache cache = null;

    public UserPermissionChecker createUserPermissionChecker(PortletRequest request, Topic topic) {
        String key = this.getCacheKey(request, topic);
        Element element = this.cache.get((Serializable)((Object)key));
        if (element == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating cache entry for " + key));
            }
            UserPermissionChecker value = new UserPermissionChecker(request, topic);
            this.cache.put(new Element((Object)key, (Object)value));
            return value;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Successfully retrieved cache entry for " + key));
        }
        return (UserPermissionChecker)element.getObjectValue();
    }

    public void afterPropertiesSet() throws Exception {
        this.cache = this.cacheManager.getCacheManager().getCache(CACHE_NAME);
        if (this.cache == null) {
            throw new BeanCreationException("Required userPermissionCheckerCache could not be loaded.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"userPermissionCheckerCache created.");
        }
    }

    private String getCacheKey(PortletRequest request, Topic topic) {
        String userId = this.userIdService.getUserId(request);
        return userId + CACHE_KEY_DELIM + topic.getTitle();
    }
}

