/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.mvc.IViewNameSelector;
import org.springframework.beans.factory.InitializingBean;

public class UserAgentViewNameSelector
implements IViewNameSelector,
InitializingBean {
    private Map<String, String> userAgentMappings;
    private final Map<Pattern, String> patterns = new HashMap();

    public void afterPropertiesSet() {
        for (Map.Entry y : this.userAgentMappings.entrySet()) {
            this.patterns.put(Pattern.compile((String)y.getKey()), y.getValue());
        }
    }

    public String select(PortletRequest req, String baseViewName) {
        if (req == null) {
            String msg = "Argument 'req' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        StringBuilder rslt = new StringBuilder(baseViewName);
        String userAgent = req.getProperty("user-agent");
        if (userAgent != null && this.patterns.size() != 0) {
            for (Map.Entry y : this.patterns.entrySet()) {
                if (!((Pattern)y.getKey()).matcher(userAgent).matches()) continue;
                rslt.append((String)y.getValue());
                break;
            }
        }
        return rslt.toString();
    }

    public void setUserAgentMappings(Map<String, String> userAgentMappings) {
        this.userAgentMappings = Collections.unmodifiableMap(userAgentMappings);
    }
}

