/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnnouncementCleanupThread
extends Thread {
    @Autowired
    private IAnnouncementService announcementService;
    private int hourToCheck = 3;
    private int minuteToCheck = 0;
    private int checkInterval = 60;
    private int expireThreshold = 60;
    private long maxCheckIntervalMillis = 43200000L;
    private boolean keepRunning;
    private static Log log = LogFactory.getLog(AnnouncementCleanupThread.class);

    public AnnouncementCleanupThread() {
        this.setDaemon(true);
        this.keepRunning = true;
    }

    public void stopThread() {
        this.keepRunning = false;
        log.info((Object)"Stopping cleanup thread...");
        this.interrupt();
    }

    @Override
    public void run() {
        if (this.expireThreshold < 0) {
            this.stopThread();
        }
        GregorianCalendar nowCal = new GregorianCalendar();
        long lastCheckTime = System.currentTimeMillis();
        boolean firstCheck = true;
        while (this.keepRunning) {
            Date now = new Date();
            nowCal.setTime(now);
            if (nowCal.get(11) == this.hourToCheck && nowCal.get(12) <= this.minuteToCheck + 1 && (firstCheck || System.currentTimeMillis() > lastCheckTime + this.maxCheckIntervalMillis)) {
                if (this.expireThreshold > 0) {
                    log.info((Object)("Going to delete old announcements at " + now.toString()));
                    this.announcementService.deleteAnnouncementsPastExpirationThreshold(this.expireThreshold);
                } else {
                    log.info((Object)("Going to delete expired announcements at " + now.toString()));
                    this.announcementService.deleteAnnouncementsPastCurrentTime();
                }
                lastCheckTime = System.currentTimeMillis();
                firstCheck = false;
            }
            try {
                log.trace((Object)"Waiting to see if we should check the time...");
                AnnouncementCleanupThread.sleep((long)(this.checkInterval * 1000));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setHourToCheck(int hourToCheck) {
        this.hourToCheck = hourToCheck;
    }

    public void setMinuteToCheck(int minuteToCheck) {
        this.minuteToCheck = minuteToCheck;
    }

    public void setMaxCheckIntervalMillis(long maxCheckIntervalMillis) {
        this.maxCheckIntervalMillis = maxCheckIntervalMillis;
    }

    public void setExpireThreshold(int expireThreshold) {
        this.expireThreshold = expireThreshold;
    }
}

