/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.mvc.portlet.display;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.mvc.IViewNameSelector;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"EDIT"})
public class AnnouncementsPreferencesController {
    @Autowired
    private ITopicSubscriptionService tss = null;
    @Autowired
    private final IAnnouncementService announcementService = null;
    @Autowired(required=true)
    private final IViewNameSelector viewNameSelector = null;
    public static final String PREFERENCE_HIDE_ABSTRACT = "AnnouncementsViewController.hideAbstract";
    private final Log logger = LogFactory.getLog(this.getClass());

    public void setTss(ITopicSubscriptionService tss) {
        this.tss = tss;
    }

    @RequestMapping
    public String editPreferences(Model model, RenderRequest request) throws PortletException {
        PortletPreferences prefs = request.getPreferences();
        List<TopicSubscription> myTopics = this.tss.getTopicSubscriptionEdit(request);
        if (request.getRemoteUser() == null) {
            model.addAttribute("isGuest", (Object)Boolean.TRUE);
        } else {
            model.addAttribute("isGuest", (Object)Boolean.FALSE);
        }
        model.addAttribute("topicSubscriptions", myTopics);
        model.addAttribute("topicsToUpdate", (Object)myTopics.size());
        model.addAttribute("prefHideAbstract", (Object)Boolean.valueOf(prefs.getValue(PREFERENCE_HIDE_ABSTRACT, "false")));
        return this.viewNameSelector.select((PortletRequest)request, "editDisplayPreferences");
    }

    @RequestMapping
    public void savePreferences(ActionRequest request, ActionResponse response, @RequestParam(value="topicsToUpdate") Integer topicsToUpdate) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        ArrayList<TopicSubscription> newSubscription = new ArrayList<TopicSubscription>();
        for (int i = 0; i < topicsToUpdate; ++i) {
            Long topicId = Long.valueOf(request.getParameter("topicId_" + i));
            String topicSubId = request.getParameter("topicSubId_" + i).trim();
            Boolean subscribed = Boolean.valueOf(request.getParameter("subscribed_" + i));
            Topic topic = this.announcementService.getTopic(topicId);
            if (topic.getSubscriptionMethod() == 1) {
                subscribed = Boolean.TRUE;
            }
            TopicSubscription ts = new TopicSubscription(request.getRemoteUser(), topic, subscribed);
            if (topicSubId.length() > 0) {
                try {
                    ts.setId(Long.valueOf(topicSubId));
                }
                catch (NumberFormatException nfe) {
                    this.logger.debug((Object)nfe.getMessage(), (Throwable)nfe);
                }
            }
            newSubscription.add(ts);
        }
        if (newSubscription.size() > 0) {
            try {
                this.announcementService.addOrSaveTopicSubscription(newSubscription);
            }
            catch (Exception e) {
                this.logger.error((Object)("ERROR saving TopicSubscriptions for user " + request.getRemoteUser() + ". Message: " + e.getMessage()));
            }
        }
        String hideAbstract = Boolean.valueOf(request.getParameter("hideAbstract")).toString();
        prefs.setValue(PREFERENCE_HIDE_ABSTRACT, hideAbstract);
        prefs.store();
        response.setPortletMode(PortletMode.VIEW);
        response.setRenderParameter("action", "displayAnnouncements");
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        boolean rslt = req.getRemoteUser() == null;
        this.logger.debug((Object)("isGuest is: " + Boolean.toString(rslt)));
        this.logger.debug((Object)("remoteUser is: " + req.getRemoteUser()));
        return rslt;
    }
}

