/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain.validation;

import edu.wisc.my.portlets.bookmarks.domain.CollectionFolder;
import edu.wisc.my.portlets.bookmarks.domain.validation.EntryValidator;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class CollectionValidator
extends EntryValidator {
    public boolean supports(Class clazz) {
        return CollectionFolder.class.isAssignableFrom(clazz) && super.supports(clazz);
    }

    public void validate(Object obj, Errors errors) {
        super.validate(obj, errors);
        CollectionFolder collection = (CollectionFolder)obj;
        this.validateUrl(collection, errors);
    }

    private void validateUrl(CollectionFolder collection, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"url", (String)"portlet.bookmark.error.url.required");
        String url = collection.getUrl();
        collection.setUrl(url);
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            errors.rejectValue("url", "portlet.bookmark.error.url.malformed");
        }
    }
}

