/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.dao.hibernate;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateBookmarkStore
extends HibernateDaoSupport
implements BookmarkStore {
    private static final String PARAM_OWNER = "owner";
    private static final String PARAM_NAME = "name";

    public BookmarkSet getBookmarkSet(String owner, String name) {
        try {
            Session session = this.getSession(false);
            Criteria c = session.createCriteria(BookmarkSet.class);
            c.add((Criterion)Restrictions.and((Criterion)this.smartEqual(PARAM_NAME, (Object)name), (Criterion)this.smartEqual(PARAM_OWNER, (Object)owner)));
            c.setCacheable(true);
            BookmarkSet bs = (BookmarkSet)c.uniqueResult();
            return bs;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void storeBookmarkSet(BookmarkSet bookmarkSet) {
        try {
            Session session = this.getSession(false);
            if (bookmarkSet.getId() == -1L) {
                this.removeBookmarkSet(bookmarkSet.getOwner(), bookmarkSet.getName());
                session.save((Object)bookmarkSet);
            }
            session.update((Object)bookmarkSet);
            session.flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void removeBookmarkSet(String owner, String name) {
        try {
            Session session = this.getSession(false);
            BookmarkSet set = this.getBookmarkSet(owner, name);
            if (set != null) {
                session.delete((Object)set);
            }
            session.flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public BookmarkSet createBookmarkSet(String owner, String name) {
        BookmarkSet bookmarkSet = new BookmarkSet();
        bookmarkSet.setOwner(owner);
        bookmarkSet.setName(name);
        bookmarkSet.setCreated(new Date());
        bookmarkSet.setModified(bookmarkSet.getCreated());
        this.storeBookmarkSet(bookmarkSet);
        return bookmarkSet;
    }

    private Criterion smartEqual(String property, Object value) {
        if (value == null) {
            return Restrictions.isNull((String)property);
        }
        return Restrictions.eq((String)property, (Object)value);
    }
}

