/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain;

import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.CollapsibleEntry;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.support.IntegerSetThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFolder
extends Entry
implements CollapsibleEntry {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CollectionFolder.class);
    private static IntegerSetThreadLocal equalsVisitedFolder = new IntegerSetThreadLocal();
    private static IntegerSetThreadLocal hashCodeVisitedFolder = new IntegerSetThreadLocal();
    private static IntegerSetThreadLocal toStringVisitedFolder = new IntegerSetThreadLocal();
    private Map<Long, Entry> children;
    private boolean minimized = false;
    private String type;
    private String url;

    public Map<Long, Entry> getChildren() {
        return new HashMap<Long, Entry>();
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getSortedChildren() {
        ArrayList<Entry> children = new ArrayList<Entry>();
        log.debug((Object)("children: " + children.size()));
        HttpClient client = new HttpClient();
        GetMethod get = null;
        try {
            log.debug((Object)("getting url " + this.url));
            get = new GetMethod(this.url);
            int rc = client.executeMethod((HttpMethod)get);
            if (rc != 200) {
                log.error((Object)("HttpStatus:" + rc));
            }
            DocumentBuilderFactory domBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domBuilderFactory.newDocumentBuilder();
            InputStream in = get.getResponseBodyAsStream();
            builder = domBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(in);
            get.releaseConnection();
            Element e = (Element)doc.getElementsByTagName("rdf:RDF").item(0);
            log.debug((Object)("got root " + e));
            NodeList n = e.getElementsByTagName("item");
            log.debug((Object)("found items " + n.getLength()));
            for (int i = 0; i < n.getLength(); ++i) {
                Bookmark bookmark = new Bookmark();
                Element l = (Element)n.item(i);
                bookmark.setName(((Element)l.getElementsByTagName("title").item(0)).getTextContent());
                bookmark.setUrl(((Element)l.getElementsByTagName("link").item(0)).getTextContent());
                if (l.getElementsByTagName("description").getLength() > 0) {
                    bookmark.setNote(((Element)l.getElementsByTagName("description").item(0)).getTextContent());
                }
                children.add((Entry)bookmark);
                log.debug((Object)("added bookmark " + bookmark.getName() + " " + bookmark.getUrl()));
            }
        }
        catch (HttpException e) {
            log.error((Object)"Error parsing delicious", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error parsing delicious", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error parsing delicious", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"Error parsing delicious", (Throwable)e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        log.debug((Object)("children: " + children.size()));
        return children;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

