/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import edu.wisc.my.portlets.bookmarks.web.support.BookmarkSetRequestResolver;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.portlet.mvc.AbstractController;

public class DeleteEntryFormController
extends AbstractController {
    protected BookmarkStore bookmarkStore;
    protected BookmarkSetRequestResolver bookmarkSetRequestResolver;

    public BookmarkSetRequestResolver getBookmarkSetRequestResolver() {
        return this.bookmarkSetRequestResolver;
    }

    public void setBookmarkSetRequestResolver(BookmarkSetRequestResolver bookmarkSetRequestResolver) {
        this.bookmarkSetRequestResolver = bookmarkSetRequestResolver;
    }

    public BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    public void setBookmarkStore(BookmarkStore bookmarkStore) {
        this.bookmarkStore = bookmarkStore;
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        String entryIndex = StringUtils.defaultIfEmpty((String)request.getParameter("entryIndex"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetEntryPathInfo = FolderUtils.getEntryInfo(bs, entryIndex);
        if (targetEntryPathInfo != null && targetEntryPathInfo.getTarget() != null) {
            Folder parentFolder = targetEntryPathInfo.getParent();
            if (parentFolder != null) {
                Map<Long, Entry> children = parentFolder.getChildren();
                Entry target = targetEntryPathInfo.getTarget();
                children.remove(target.getId());
                this.bookmarkStore.storeBookmarkSet(bs);
            } else {
                this.bookmarkStore.removeBookmarkSet(bs.getOwner(), bs.getName());
            }
        } else {
            this.logger.warn((Object)("No IdPathInfo found for BaseFolder='" + bs + "' and idPath='" + entryIndex + "'"));
        }
        response.setRenderParameter("action", "viewBookmarks");
    }
}

