/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import edu.wisc.my.portlets.bookmarks.web.support.BookmarkSetRequestResolver;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.portlet.mvc.AbstractController;

public class ToggleFolderFormController
extends AbstractController {
    protected BookmarkStore bookmarkStore;
    protected BookmarkSetRequestResolver bookmarkSetRequestResolver;

    public BookmarkSetRequestResolver getBookmarkSetRequestResolver() {
        return this.bookmarkSetRequestResolver;
    }

    public void setBookmarkSetRequestResolver(BookmarkSetRequestResolver bookmarkSetRequestResolver) {
        this.bookmarkSetRequestResolver = bookmarkSetRequestResolver;
    }

    public BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    public void setBookmarkStore(BookmarkStore bookmarkStore) {
        this.bookmarkStore = bookmarkStore;
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        String folderIndex = StringUtils.defaultIfEmpty((String)request.getParameter("folderIndex"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetFolderPathInfo = FolderUtils.getEntryInfo((Folder)bs, (String)folderIndex);
        if (targetFolderPathInfo != null && targetFolderPathInfo.getTarget() != null) {
            Folder targetFolder;
            targetFolder.setMinimized(!(targetFolder = (Folder)targetFolderPathInfo.getTarget()).isMinimized());
            this.bookmarkStore.storeBookmarkSet(bs);
        } else {
            this.logger.warn((Object)("No IdPathInfo found for BaseFolder='" + bs + "' and idPath='" + folderIndex + "'"));
        }
        response.setRenderParameter("action", "viewBookmarks");
    }
}

