/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import edu.wisc.my.portlets.bookmarks.web.BaseEntryFormController;
import java.util.Date;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.BindException;

public class EditFolderFormController
extends BaseEntryFormController {
    protected Object formBackingObject(PortletRequest request) throws Exception {
        return super.formBackingObject(request);
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        String targetEntryPath = StringUtils.defaultIfEmpty((String)request.getParameter("idPath"), null);
        Folder commandFolder = (Folder)command;
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
        if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
        }
        Folder targetParent = (Folder)targetParentPathInfo.getTarget();
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        IdPathInfo originalBookmarkPathInfo = FolderUtils.getEntryInfo(bs, targetEntryPath);
        if (targetParentPathInfo == null || originalBookmarkPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetEntryPath + "'");
        }
        Folder originalParent = originalBookmarkPathInfo.getParent();
        Folder orignalFolder = (Folder)originalBookmarkPathInfo.getTarget();
        if (targetParent.getId() != originalParent.getId()) {
            Map<Long, Entry> originalChildren = originalParent.getChildren();
            originalChildren.remove(orignalFolder.getId());
            commandFolder.setCreated(orignalFolder.getCreated());
            commandFolder.setModified(new Date());
            commandFolder.setChildren(orignalFolder.getChildren());
            Folder clonedCommandFolder = FolderUtils.deepCloneFolder(commandFolder, false);
            targetChildren.put(clonedCommandFolder.getId(), clonedCommandFolder);
        } else {
            orignalFolder.setModified(new Date());
            orignalFolder.setName(commandFolder.getName());
            orignalFolder.setNote(commandFolder.getNote());
        }
        this.bookmarkStore.storeBookmarkSet(bs);
    }
}

