/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.dao.PreferencesStore;
import edu.wisc.my.portlets.bookmarks.domain.Preferences;
import edu.wisc.my.portlets.bookmarks.domain.validation.PreferencesValidator;
import edu.wisc.my.portlets.bookmarks.web.support.PreferencesRequestResolver;
import java.util.Date;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PreferencesController {
    private static final Logger logger = LoggerFactory.getLogger(PreferencesController.class);
    @Autowired
    private PreferencesRequestResolver preferencesRequestResolver;
    @Resource(name="preferencesStore")
    private PreferencesStore preferencesStore;
    private final PreferencesValidator validator = new PreferencesValidator();

    @ModelAttribute
    private Preferences getPreferences(PortletRequest request) {
        return this.preferencesRequestResolver.getPreferences(request);
    }

    @RenderMapping(params={"action=saveOptions"})
    public String showOptionsForm(Model model, PortletRequest request) {
        logger.debug("prefs render");
        Preferences prefs = this.getPreferences(request);
        logger.debug("prefs (options): {}", (Object)prefs);
        model.addAttribute("options", (Object)prefs);
        return "editBookmarks";
    }

    @ActionMapping(params={"action=saveOptions"})
    public void saveOptions(@ModelAttribute(value="options") Preferences prefs, BindingResult result, ActionRequest request, ActionResponse response) {
        logger.debug("prefs action");
        if (request.getRemoteUser() == null) {
            logger.warn("guest user should not be saving options");
            return;
        }
        this.populatePreferences(prefs, request);
        this.validator.validate(prefs, (Errors)result);
        logger.debug("prefs: {}", (Object)prefs);
        logger.debug("results: {}", (Object)result);
        if (!result.hasErrors()) {
            logger.debug("no errors");
            prefs.setModified(new Date());
            this.preferencesStore.storePreferences(prefs);
            response.setRenderParameter("action", "viewBookmarks");
        } else {
            logger.warn("prefs errors!");
            request.setAttribute("errors", (Object)result);
            response.setRenderParameter("action", "saveOptions");
        }
    }

    private void populatePreferences(Preferences preferences, ActionRequest request) {
        Preferences savedPreferences = this.getPreferences((PortletRequest)request);
        preferences.setId(savedPreferences.getId());
        preferences.setOwner(savedPreferences.getOwner());
        preferences.setName(savedPreferences.getName());
        preferences.setCreated(savedPreferences.getCreated() != null ? savedPreferences.getCreated() : new Date());
        preferences.setModified(savedPreferences.getModified() != null ? savedPreferences.getModified() : new Date());
    }
}

