/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.CollectionFolder;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.Preferences;
import edu.wisc.my.portlets.bookmarks.web.support.BookmarkSetRequestResolver;
import edu.wisc.my.portlets.bookmarks.web.support.PreferencesRequestResolver;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class ReferenceData {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceData.class);
    @Autowired
    private BookmarkSetRequestResolver bookmarkSetRequestResolver;
    @Autowired
    private PreferencesRequestResolver preferencesRequestResolver;
    @Resource(name="bookmarkStore")
    private BookmarkStore bookmarkStore;
    @Resource(name="availableCollections")
    private Map availableCollections;

    public Map<String, Object> getRefData(RenderRequest request, Errors errors) {
        logger.debug("Entering getRefData()");
        BookmarkSet bookmarkSet = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        HashMap<String, Object> refData = new HashMap<String, Object>();
        refData.put("bookmarkSet", bookmarkSet);
        if (errors != null) {
            refData.put("errors", errors);
        }
        refData.put("emptyBookmarkCommand", new Bookmark());
        refData.put("emptyFolderCommand", new Folder());
        refData.put("availableCollections", this.availableCollections);
        refData.put("emptyCollectionCommand", new CollectionFolder());
        if (request.getRemoteUser() == null) {
            logger.debug("guestMode = true");
            refData.put("guestMode", true);
            refData.put("options", new Preferences());
        } else {
            refData.put("guestMode", false);
            logger.debug("guestMode = false");
            Preferences preferences = this.preferencesRequestResolver.getPreferences((PortletRequest)request, true);
            refData.put("options", preferences);
        }
        return refData;
    }
}

