/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import com.microsoft.exchange.messages.FreeBusyResponseType;
import com.microsoft.exchange.messages.GetUserAvailabilityRequest;
import com.microsoft.exchange.messages.GetUserAvailabilityResponse;
import com.microsoft.exchange.types.ArrayOfCalendarEvent;
import com.microsoft.exchange.types.ArrayOfMailboxData;
import com.microsoft.exchange.types.DayOfWeekType;
import com.microsoft.exchange.types.Duration;
import com.microsoft.exchange.types.FreeBusyViewOptions;
import com.microsoft.exchange.types.Mailbox;
import com.microsoft.exchange.types.MailboxData;
import com.microsoft.exchange.types.MeetingAttendeeType;
import com.microsoft.exchange.types.SerializableTimeZoneTime;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.soap.client.core.SoapActionCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeCalendarAdapter
implements ICalendarAdapter {
    protected static final String AVAILABILITY_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/GetUserAvailability";
    protected static final String UTC = "UTC";
    protected final Log log = LogFactory.getLog(this.getClass());
    private WebServiceOperations webServiceOperations;
    private Cache cache;
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "exchange";
    private String emailAttribute = "mail";

    public void setWebServiceOperations(WebServiceOperations webServiceOperations) {
        this.webServiceOperations = webServiceOperations;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    @Override
    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, PortletRequest request) throws CalendarException {
        Set<CalendarEvent> events = Collections.emptySet();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String email = (String)userInfo.get(this.emailAttribute);
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(email));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            this.log.debug((Object)("Retreiving exchange events for account " + email));
            events = this.retrieveExchangeEvents(calendarConfiguration, period, email);
            this.log.debug((Object)("Exchange adapter found " + events.size() + " events"));
            cachedElement = new Element((Object)key, events);
            this.cache.put(cachedElement);
        } else {
            events = (Set<CalendarEvent>)((Object)cachedElement.getValue());
        }
        return events;
    }

    public Set<CalendarEvent> retrieveExchangeEvents(CalendarConfiguration calendar, Period period, String emailAddress) throws CalendarException {
        if (this.log.isDebugEnabled()) {
            StringBuilder buff = new StringBuilder();
            buff.append("Period details:  start=").append(period.getStart()).append(", end=").append(period.getEnd());
            this.log.debug((Object)buff.toString());
        }
        HashSet<CalendarEvent> events = new HashSet<CalendarEvent>();
        try {
            GetUserAvailabilityRequest soapRequest = this.getAvailabilityRequest(period, emailAddress);
            GetUserAvailabilityResponse response = (GetUserAvailabilityResponse)this.webServiceOperations.marshalSendAndReceive((Object)soapRequest, (WebServiceMessageCallback)new SoapActionCallback(AVAILABILITY_SOAP_ACTION));
            for (FreeBusyResponseType freeBusy : response.getFreeBusyResponseArray().getFreeBusyResponses()) {
                ArrayOfCalendarEvent eventArray = freeBusy.getFreeBusyView().getCalendarEventArray();
                if (eventArray == null || eventArray.getCalendarEvents() == null) continue;
                List<com.microsoft.exchange.types.CalendarEvent> msEvents = eventArray.getCalendarEvents();
                for (com.microsoft.exchange.types.CalendarEvent msEvent : msEvents) {
                    CalendarEvent event = this.getInternalEvent(calendar.getId(), msEvent);
                    events.add(event);
                }
            }
        }
        catch (DatatypeConfigurationException e) {
            throw new CalendarException(e);
        }
        return events;
    }

    @Override
    public String getLink(CalendarConfiguration calendar, Period period, PortletRequest request) throws CalendarLinkException {
        return "";
    }

    protected GetUserAvailabilityRequest getAvailabilityRequest(Period period, String emailAddress) throws DatatypeConfigurationException {
        GetUserAvailabilityRequest soapRequest = new GetUserAvailabilityRequest();
        ArrayOfMailboxData mailboxes = new ArrayOfMailboxData();
        MailboxData mailbox = new MailboxData();
        Mailbox address = new Mailbox();
        address.setAddress(emailAddress);
        address.setName("");
        mailbox.setAttendeeType(MeetingAttendeeType.REQUIRED);
        mailbox.setExcludeConflicts(false);
        mailbox.setEmail(address);
        mailboxes.getMailboxDatas().add(mailbox);
        soapRequest.setMailboxDataArray(mailboxes);
        FreeBusyViewOptions view = new FreeBusyViewOptions();
        view.setMergedFreeBusyIntervalInMinutes(60);
        view.getRequestedView().add("DetailedMerged");
        Duration dur = new Duration();
        XMLGregorianCalendar start = this.getXmlDate((Date)period.getStart());
        XMLGregorianCalendar end = this.getXmlDate((Date)period.getEnd());
        dur.setEndTime(end);
        dur.setStartTime(start);
        view.setTimeWindow(dur);
        soapRequest.setFreeBusyViewOptions(view);
        com.microsoft.exchange.types.TimeZone tz = new com.microsoft.exchange.types.TimeZone();
        TimeZone tZone = TimeZone.getTimeZone(UTC);
        tz.setBias(tZone.getRawOffset() / 1000 / 60);
        SerializableTimeZoneTime standard = new SerializableTimeZoneTime();
        standard.setBias(0);
        standard.setDayOfWeek(DayOfWeekType.SUNDAY);
        standard.setDayOrder((short)1);
        standard.setMonth((short)11);
        standard.setTime("02:00:00");
        SerializableTimeZoneTime daylight = new SerializableTimeZoneTime();
        daylight.setBias(0);
        daylight.setDayOfWeek(DayOfWeekType.SUNDAY);
        daylight.setDayOrder((short)1);
        daylight.setMonth((short)3);
        daylight.setTime("02:00:00");
        tz.setStandardTime(standard);
        tz.setDaylightTime(daylight);
        soapRequest.setTimeZone(tz);
        return soapRequest;
    }

    protected CalendarEvent getInternalEvent(long calendarId, com.microsoft.exchange.types.CalendarEvent msEvent) throws DatatypeConfigurationException {
        DatatypeFactory factory = DatatypeFactory.newInstance();
        DateTime eventStart = new DateTime();
        eventStart.setUtc(true);
        GregorianCalendar startCal = msEvent.getStartTime().toGregorianCalendar(TimeZone.getTimeZone(UTC), Locale.getDefault(), factory.newXMLGregorianCalendar());
        eventStart.setTime(startCal.getTimeInMillis());
        DateTime eventEnd = new DateTime();
        eventEnd.setUtc(true);
        GregorianCalendar endCal = msEvent.getEndTime().toGregorianCalendar(TimeZone.getTimeZone(UTC), Locale.getDefault(), factory.newXMLGregorianCalendar());
        eventEnd.setTime(endCal.getTimeInMillis());
        PropertyList newprops = new PropertyList();
        newprops.add((Property)new DtStart((Date)eventStart));
        newprops.add((Property)new DtEnd((Date)eventEnd));
        newprops.add((Property)new Summary(msEvent.getCalendarEventDetails().getSubject()));
        if (StringUtils.isNotBlank((String)msEvent.getCalendarEventDetails().getLocation())) {
            newprops.add((Property)new Location(msEvent.getCalendarEventDetails().getLocation()));
        }
        CalendarEvent event = new CalendarEvent(calendarId, newprops);
        return event;
    }

    protected XMLGregorianCalendar getXmlDate(Date date) throws DatatypeConfigurationException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(UTC));
        cal.setTimeInMillis(date.getTime());
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar start = datatypeFactory.newXMLGregorianCalendar();
        start.setYear(cal.get(1));
        start.setMonth(cal.get(2) + 1);
        start.setTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        start.setDay(cal.get(5));
        return start;
    }
}

