/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.util.AllDayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonCalendarEvent
implements Comparable<JsonCalendarEvent> {
    private final CalendarEvent event;
    private final Date dayStart;
    private final Date dayEnd;
    private final DateFormat tf;
    private final DateFormat df;
    private final boolean isAllDay;
    private final boolean isMultiDay;
    private final int colorIndex;

    public JsonCalendarEvent(CalendarEvent event, Date date, TimeZone tz, int colorIndex) {
        this.event = event;
        this.colorIndex = colorIndex;
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        boolean multi = false;
        if (event.getStartDate().getDate().before(cal.getTime())) {
            this.dayStart = cal.getTime();
            multi = true;
        } else {
            this.dayStart = event.getStartDate().getDate();
        }
        cal.add(5, 1);
        if (event.getEndDate().getDate().after(cal.getTime())) {
            this.dayEnd = cal.getTime();
            multi = true;
        } else {
            this.dayEnd = event.getEndDate().getDate();
        }
        this.isMultiDay = multi;
        this.df = new SimpleDateFormat("EEEE MMMM d");
        this.df.setTimeZone(tz);
        this.tf = new SimpleDateFormat("h:mm a");
        this.tf.setTimeZone(tz);
        this.isAllDay = AllDayUtil.isAllDayEvent(this.dayStart, this.dayEnd, tz);
    }

    public String getSummary() {
        if (this.event.getSummary() != null) {
            return this.event.getSummary().getValue();
        }
        return null;
    }

    public String getDescription() {
        if (this.event.getDescription() != null) {
            return this.event.getDescription().getValue();
        }
        return null;
    }

    public String getLocation() {
        if (this.event.getLocation() != null) {
            return this.event.getLocation().getValue();
        }
        return null;
    }

    public Long getCalendarId() {
        return this.event.getCalendarId();
    }

    public String getDateStartTime() {
        return this.tf.format(this.dayStart);
    }

    public String getDateEndTime() {
        if (this.event.getEndDate() != null) {
            return this.tf.format(this.dayEnd);
        }
        return null;
    }

    public String getStartTime() {
        return this.tf.format((Date)this.event.getStartDate().getDate());
    }

    public String getEndTime() {
        if (this.event.getEndDate() != null) {
            return this.tf.format((Date)this.event.getEndDate().getDate());
        }
        return null;
    }

    public String getStartDate() {
        return this.df.format((Date)this.event.getStartDate().getDate());
    }

    public String getEndDate() {
        if (this.event.getEndDate() != null) {
            return this.df.format((Date)this.event.getEndDate().getDate());
        }
        return null;
    }

    public boolean isAllDay() {
        return this.isAllDay;
    }

    public boolean isMultiDay() {
        return this.isMultiDay;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public Date getDayStart() {
        return this.dayStart;
    }

    public Date getDayEnd() {
        return this.dayEnd;
    }

    @Override
    public int compareTo(JsonCalendarEvent event) {
        return new CompareToBuilder().append((Object)this.dayStart, (Object)event.dayStart).append((Object)this.dayEnd, (Object)event.dayEnd).append((Object)this.getSummary(), (Object)event.getSummary()).append((Object)this.getCalendarId(), (Object)event.getCalendarId()).toComparison();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JsonCalendarEvent)) {
            return false;
        }
        JsonCalendarEvent event = (JsonCalendarEvent)o;
        return new EqualsBuilder().append((Object)this.dayStart, (Object)event.dayStart).append((Object)this.dayEnd, (Object)event.dayEnd).append((Object)this.getSummary(), (Object)event.getSummary()).append((Object)this.getCalendarId(), (Object)event.getCalendarId()).isEquals();
    }
}

