/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.processor.ICalendarContentProcessorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTICalendarContentProcessorImpl
extends ICalendarContentProcessorImpl {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String xslFile;

    public XSLTICalendarContentProcessorImpl() {
    }

    public XSLTICalendarContentProcessorImpl(String xslFile) {
        this.xslFile = xslFile;
    }

    @Override
    public Set<CalendarEvent> getEvents(Long calendarId, Period period, InputStream in) {
        InputStream ical = this.transformToICal(in);
        return super.getEvents(calendarId, period, ical);
    }

    protected final InputStream transformToICal(InputStream in) throws CalendarException {
        StreamSource xmlSource = new StreamSource(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.log.debug((Object)("Stylesheet is " + this.xslFile));
            InputStream xsl = this.getClass().getClassLoader().getResourceAsStream(this.xslFile);
            Transformer tx = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
            tx.transform(xmlSource, new StreamResult(out));
            this.log.debug((Object)out.toString());
            ByteArrayInputStream result = new ByteArrayInputStream(out.toByteArray());
            return result;
        }
        catch (TransformerConfigurationException tce) {
            this.log.error((Object)"Failed to configure transformer", (Throwable)tce);
            throw new CalendarException("Failed to configure transformer", tce);
        }
        catch (TransformerException txe) {
            throw new CalendarException("Failed transformation", txe);
        }
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }
}

