/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.DefaultTimeZoneRegistryFactory;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarConfigurationByNameComparator;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.adapter.UserFeedbackCalendarException;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.JsonCalendarEvent;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class AjaxCalendarController
implements ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ICalendarSetDao calendarSetDao;
    private ApplicationContext applicationContext;
    private AjaxPortletSupportService ajaxPortletSupportService;

    @RequestMapping(params={"action=events"})
    public void getEventList(ActionRequest request, ActionResponse response) throws Exception {
        PortletSession session = request.getPortletSession();
        HashMap<String, Object> model = new HashMap<String, Object>();
        CalendarSet set = this.calendarSetDao.getCalendarSet((PortletRequest)request);
        ArrayList calendars = new ArrayList();
        calendars.addAll(set.getConfigurations());
        Collections.sort(calendars, new CalendarConfigurationByNameComparator());
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        Period period = this.getPeriod(request);
        String timezone = (String)session.getAttribute("timezone");
        TimeZone tz = TimeZone.getTimeZone(timezone);
        DefaultTimeZoneRegistryFactory tzFactory = new DefaultTimeZoneRegistryFactory();
        TimeZoneRegistry tzRegistry = tzFactory.createRegistry();
        int index = 0;
        ArrayList<String> errors = new ArrayList<String>();
        TreeSet events = new TreeSet();
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                    for (CalendarEvent e : adapter.getEvents(callisting, period, (PortletRequest)request)) {
                        CalendarEvent event = (CalendarEvent)e.copy();
                        if (event.getStartDate().getTimeZone() == null && !event.getStartDate().isUtc()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Identified event " + event.getSummary() + " as a floating event"));
                            }
                            int offset = tz.getOffset(event.getStartDate().getDate().getTime());
                            event.getStartDate().getDate().setTime(event.getStartDate().getDate().getTime() - (long)offset);
                            if (event.getEndDate() != null) {
                                event.getEndDate().getDate().setTime(event.getEndDate().getDate().getTime() - (long)offset);
                            }
                        } else if (event.getStartDate().isUtc()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Setting time zone to UTC for  event " + event.getSummary()));
                            }
                            event.getStartDate().setTimeZone(tzRegistry.getTimeZone("UTC"));
                            if (event.getEndDate() != null) {
                                event.getEndDate().setTimeZone(tzRegistry.getTimeZone("UTC"));
                            }
                        }
                        events.addAll(this.getJsonEvents(event, period, tz, index));
                    }
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (UserFeedbackCalendarException sce) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(callisting.getCalendarDefinition().getName()).append(":  ").append(sce.getUserFeedback());
                    errors.add(msg.toString());
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Unknown Error", (Throwable)ex);
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
            }
            ++index;
        }
        SimpleDateFormat orderableDf = new SimpleDateFormat("yyyy-MM-dd");
        orderableDf.setTimeZone(tz);
        SimpleDateFormat displayDf = new SimpleDateFormat("EEEE MMMM d");
        displayDf.setTimeZone(tz);
        Calendar cal = Calendar.getInstance(tz);
        String today = orderableDf.format(cal.getTime());
        cal.add(5, 1);
        String tomorrow = orderableDf.format(cal.getTime());
        HashMap<String, String> dateDisplayNames = new HashMap<String, String>();
        LinkedHashMap eventsByDay = new LinkedHashMap();
        for (JsonCalendarEvent event : events) {
            String day = orderableDf.format(event.getDayStart());
            if (!eventsByDay.containsKey(day)) {
                eventsByDay.put(day, new ArrayList());
                if (today.equals(day)) {
                    dateDisplayNames.put(day, "Today");
                } else if (tomorrow.equals(day)) {
                    dateDisplayNames.put(day, "Tomorrow");
                } else {
                    dateDisplayNames.put(day, displayDf.format(event.getDayStart()));
                }
            }
            ((List)eventsByDay.get(day)).add(event);
        }
        model.put("dateMap", eventsByDay);
        model.put("dateNames", dateDisplayNames);
        model.put("viewName", "jsonView");
        model.put("errors", errors);
        this.ajaxPortletSupportService.redirectAjaxResponse("ajax/jsonView", model, request, response);
    }

    protected Set<JsonCalendarEvent> getJsonEvents(CalendarEvent event, Period period, TimeZone tz, int index) throws IOException, URISyntaxException, ParseException {
        Calendar dayStart = Calendar.getInstance(tz);
        dayStart.setTime((Date)event.getStartDate().getDate());
        dayStart.set(10, 0);
        dayStart.set(12, 0);
        dayStart.set(13, 0);
        dayStart.set(14, 1);
        Calendar dayEnd = (Calendar)dayStart.clone();
        dayEnd.add(5, 1);
        Calendar eventEnd = Calendar.getInstance(tz);
        eventEnd.setTime((Date)event.getEndDate().getDate());
        HashSet<JsonCalendarEvent> events = new HashSet<JsonCalendarEvent>();
        do {
            JsonCalendarEvent json;
            if (period.includes((json = new JsonCalendarEvent(event, dayStart.getTime(), tz, index)).getDayStart(), 1) || period.includes(json.getDayEnd(), 2)) {
                events.add(json);
            }
            dayStart.add(5, 1);
            dayEnd.add(5, 1);
        } while (dayStart.before(eventEnd));
        return events;
    }

    protected Period getPeriod(ActionRequest request) {
        PortletSession session = request.getPortletSession();
        PortletPreferences prefs = request.getPreferences();
        Calendar cal = null;
        String timezone = (String)session.getAttribute("timezone");
        TimeZone tz = TimeZone.getTimeZone(timezone);
        Date startDate = (Date)session.getAttribute("startDate");
        SimpleDateFormat df = new SimpleDateFormat("MM'/'dd'/'yyyy");
        df.setTimeZone(tz);
        String requestedDate = request.getParameter("startDate");
        if (requestedDate != null && !requestedDate.equals("")) {
            try {
                startDate = df.parse(requestedDate);
                cal = Calendar.getInstance(tz);
                cal.setTime(startDate);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 1);
                startDate = cal.getTime();
                session.setAttribute("startDate", (Object)cal.getTime());
            }
            catch (ParseException ex) {
                this.log.warn((Object)"Failed to parse starting date for event", (Throwable)ex);
            }
        }
        if (cal == null) {
            cal = Calendar.getInstance(tz);
            cal.setTime((Date)session.getAttribute("startDate"));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 1);
        }
        startDate = cal.getTime();
        this.log.debug((Object)("start date: " + cal));
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
                if (!prefs.isReadOnly("days")) {
                    prefs.setValue("days", Integer.toString(days));
                    prefs.store();
                }
            }
            catch (NumberFormatException ex) {
                this.log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
            catch (ReadOnlyException ex) {
                this.log.error((Object)"Failed to set 'days' preference because it is read only", (Throwable)ex);
            }
            catch (IOException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
            catch (ValidatorException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
        }
        cal.add(5, days);
        cal.set(14, 1);
        Date endDate = cal.getTime();
        return new Period(new DateTime(startDate), new DateTime(endDate));
    }

    @Autowired(required=true)
    public void setCalendarSetDao(ICalendarSetDao calendarSetDao) {
        this.calendarSetDao = calendarSetDao;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }
}

