/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.portlet;

import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.portlet.ICASProxyTicketService;
import edu.yale.its.tp.cas.proxy.ProxyTicketReceptor;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class CASProxyTicketServiceUserInfoImpl
implements ICASProxyTicketService {
    private static Log log = LogFactory.getLog(CASProxyTicketServiceUserInfoImpl.class);
    private String casValidateUrl = "https://secure.its.yale.edu/cas/proxyValidate";
    private String serviceUrl = "https://portaltest.its.yale.edu/CalendarPortlet";
    private String urlOfProxyCallbackServlet = "https://portaltest.its.yale.edu/CalendarPortlet/CasProxyCallback";

    public CASReceipt getProxyTicket(PortletRequest request) {
        Map userinfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String ticket = (String)userinfo.get("casProxyTicket");
        if (ticket == null) {
            log.debug((Object)"No CAS ticket found in the UserInfo map");
            return null;
        }
        String errorCode = null;
        String errorMessage = null;
        String xmlResponse = null;
        log.trace((Object)("validateURL: " + this.casValidateUrl + ", serviceURL: " + this.serviceUrl + ", ticket: " + ticket + ", callbackUrl: " + this.urlOfProxyCallbackServlet));
        ProxyTicketValidator pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(this.casValidateUrl);
        pv.setService(this.serviceUrl);
        pv.setServiceTicket(ticket);
        pv.setProxyCallbackUrl(this.urlOfProxyCallbackServlet);
        try {
            pv.validate();
        }
        catch (IOException e) {
            log.warn((Object)"Failed to validate proxy ticket", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.warn((Object)"Failed to validate proxy ticket", (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)"Failed to validate proxy ticket", (Throwable)e);
            return null;
        }
        xmlResponse = pv.getResponse();
        log.trace((Object)("response: " + xmlResponse));
        if (pv.isAuthenticationSuccesful()) {
            log.trace((Object)"authentication successful");
        } else {
            errorCode = pv.getErrorCode();
            errorMessage = pv.getErrorMessage();
            log.trace((Object)("cas error! " + errorCode + ": " + errorMessage));
        }
        CASReceipt receipt = new CASReceipt();
        receipt.setPgtIou(pv.getPgtIou());
        receipt.setUserName(pv.getUser());
        return receipt;
    }

    public String getCasServiceToken(CASReceipt receipt, String target) {
        String proxyTicket;
        String pgtIou = receipt.getPgtIou();
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getCasServiceToken(" + target + "), previously cached receipt=[" + pgtIou + "]"));
        }
        if (pgtIou == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returning null CAS Service Token because cached receipt does not include a PGTIOU.");
            }
            return null;
        }
        try {
            proxyTicket = ProxyTicketReceptor.getProxyTicket((String)pgtIou, (String)target);
        }
        catch (IOException e) {
            log.error((Object)"Error contacting CAS server for proxy ticket", (Throwable)e);
            return null;
        }
        if (proxyTicket == null) {
            log.error((Object)("Failed to obtain proxy ticket using receipt [" + pgtIou + "], has the Proxy Granting Ticket referenced by the pgtIou expired?"));
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getCasServiceToken(), returning proxy ticket [" + proxyTicket + "]"));
        }
        return proxyTicket;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setUrlOfProxyCallbackServlet(String urlOfProxyCallbackServlet) {
        this.urlOfProxyCallbackServlet = urlOfProxyCallbackServlet;
    }
}

