/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.adapter;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.CalendarEvent;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarLinkException;
import edu.yale.its.tp.portlets.calendar.adapter.ICalendarAdapter;
import edu.yale.its.tp.portlets.calendar.adapter.ISingleEventSupport;
import edu.yale.its.tp.portlets.calendar.caching.DefaultCacheKeyGeneratorImpl;
import edu.yale.its.tp.portlets.calendar.caching.ICacheKeyGenerator;
import edu.yale.its.tp.portlets.calendar.credentials.DefaultCredentialsExtractorImpl;
import edu.yale.its.tp.portlets.calendar.credentials.ICredentialsExtractor;
import edu.yale.its.tp.portlets.calendar.processor.ICalendarContentProcessorImpl;
import edu.yale.its.tp.portlets.calendar.processor.IContentProcessor;
import edu.yale.its.tp.portlets.calendar.url.DefaultUrlCreatorImpl;
import edu.yale.its.tp.portlets.calendar.url.IUrlCreator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.model.Period;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurableHttpCalendarAdapter
implements ICalendarAdapter,
ISingleEventSupport {
    private Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private IUrlCreator urlCreator = new DefaultUrlCreatorImpl();
    private ICredentialsExtractor credentialsExtractor = new DefaultCredentialsExtractorImpl();
    private IContentProcessor contentProcessor = new ICalendarContentProcessorImpl();
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "default";

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setUrlCreator(IUrlCreator urlCreator) {
        this.urlCreator = urlCreator;
    }

    public void setCredentialsExtractor(ICredentialsExtractor credentialsExtractor) {
        this.credentialsExtractor = credentialsExtractor;
    }

    public void setContentProcessor(IContentProcessor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, PortletRequest request) throws CalendarException {
        Set events = Collections.emptySet();
        String url = this.urlCreator.constructUrl(calendarConfiguration, period, request);
        this.log.debug((Object)("generated url: " + url));
        Credentials credentials = this.credentialsExtractor.getCredentials(request);
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(url));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            InputStream stream = this.retrieveCalendarHttp(url, credentials);
            events = this.contentProcessor.getEvents(calendarConfiguration.getId(), period, stream);
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            cachedElement = new Element((Object)key, (Object)events);
            this.cache.put(cachedElement);
        } else {
            events = (Set)((Object)cachedElement.getValue());
        }
        return events;
    }

    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, HttpServletRequest request) throws CalendarException {
        Set events = Collections.emptySet();
        String url = this.urlCreator.constructUrl(calendarConfiguration, period, request);
        this.log.debug((Object)("generated url: " + url));
        Credentials credentials = this.credentialsExtractor.getCredentials(request);
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(url));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            InputStream stream = this.retrieveCalendarHttp(url, credentials);
            events = this.contentProcessor.getEvents(calendarConfiguration.getId(), period, stream);
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            cachedElement = new Element((Object)key, (Object)events);
            this.cache.put(cachedElement);
        } else {
            events = (Set)((Object)cachedElement.getValue());
        }
        return events;
    }

    public CalendarEvent getEvent(CalendarConfiguration calendar, Period period, String uid, String recurrenceId, HttpServletRequest request) throws CalendarException {
        Set events = this.getEvents(calendar, period, request);
        for (CalendarEvent event : events) {
            if (!event.getUid().toString().equals(uid) || null != recurrenceId && !event.getRecurrenceId().toString().equals(recurrenceId)) continue;
            return event;
        }
        this.log.debug((Object)("event not found with uid " + uid + " and recurrence id " + recurrenceId));
        return null;
    }

    public CalendarEvent getEvent(CalendarConfiguration calendar, Period period, String uid, String recurrenceId, PortletRequest request) throws CalendarException {
        Set events = this.getEvents(calendar, period, request);
        for (CalendarEvent event : events) {
            if (!event.getUid().toString().equals(uid) || null != recurrenceId && !event.getRecurrenceId().toString().equals(recurrenceId)) continue;
            return event;
        }
        this.log.debug((Object)("event not found with uid " + uid + " and recurrence id " + recurrenceId));
        return null;
    }

    public String getLink(CalendarConfiguration calendar, Period period, PortletRequest request) {
        throw new CalendarLinkException("This calendar has no link");
    }

    protected InputStream retrieveCalendarHttp(String url, Credentials credentials) throws CalendarException {
        HttpClient client = new HttpClient();
        if (null != credentials) {
            client.getState().setCredentials(AuthScope.ANY, credentials);
        }
        GetMethod get = null;
        try {
            int rc;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving calendar " + url));
            }
            if ((rc = client.executeMethod((HttpMethod)(get = new GetMethod(url)))) == 200) {
                this.log.debug((Object)"request completed successfully");
                InputStream in = get.getResponseBodyAsStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)in, (OutputStream)buffer);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
                return byteArrayInputStream;
            }
            try {
                this.log.warn((Object)("HttpStatus for " + url + ":" + rc));
                throw new CalendarException("non successful status code retrieving " + url + ", status code: " + rc);
            }
            catch (HttpException e) {
                this.log.warn((Object)"Error fetching iCalendar feed", (Throwable)e);
                throw new CalendarException("Error fetching iCalendar feed", (Throwable)e);
            }
            catch (IOException e) {
                this.log.warn((Object)"Error fetching iCalendar feed", (Throwable)e);
                throw new CalendarException("Error fetching iCalendar feed", (Throwable)e);
            }
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }
}

