/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.credentials;

import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.credentials.ICredentialsExtractor;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestAttributeCredentialsExtractorImpl
implements ICredentialsExtractor {
    private Log log = LogFactory.getLog(this.getClass());
    private String usernameAttribute = "username";
    private String passwordAttribute = "password";

    public RequestAttributeCredentialsExtractorImpl() {
    }

    public RequestAttributeCredentialsExtractorImpl(String passwordAttribute, String usernameAttribute) {
        this.passwordAttribute = passwordAttribute;
        this.usernameAttribute = usernameAttribute;
    }

    public Credentials getCredentials(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.log.error((Object)"null session");
            throw new CalendarException();
        }
        String username = (String)session.getAttribute(this.usernameAttribute);
        if (username == null) {
            this.log.error((Object)("username attribute (" + this.usernameAttribute + ") does not exist in session"));
            throw new CalendarException();
        }
        String password = (String)session.getAttribute(this.passwordAttribute);
        if (password == null) {
            this.log.error((Object)("password attribute (" + this.passwordAttribute + ") does not exist in session"));
            throw new CalendarException();
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public Credentials getCredentials(PortletRequest request) {
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            this.log.error((Object)"null session");
            throw new CalendarException();
        }
        String username = (String)session.getAttribute(this.usernameAttribute);
        if (username == null) {
            this.log.error((Object)("username attribute (" + this.usernameAttribute + ") does not exist in session"));
            throw new CalendarException();
        }
        String password = (String)session.getAttribute(this.passwordAttribute);
        if (password == null) {
            this.log.error((Object)("password attribute (" + this.passwordAttribute + ") does not exist in session"));
            throw new CalendarException();
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }
}

