/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.dao;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.CalendarDefinition;
import edu.yale.its.tp.portlets.calendar.PredefinedCalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.PredefinedCalendarDefinition;
import edu.yale.its.tp.portlets.calendar.UserDefinedCalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCalendarStore
extends HibernateDaoSupport
implements CalendarStore {
    private static Log log = LogFactory.getLog(HibernateCalendarStore.class);

    public void storeCalendarDefinition(CalendarDefinition listing) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)listing);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void storeCalendarConfiguration(CalendarConfiguration configuration) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<CalendarConfiguration> getCalendarConfigurations(String subscribeId) {
        try {
            log.debug((Object)("fetching calendar configurations for " + subscribeId));
            return this.getHibernateTemplate().find("from CalendarConfiguration config where subscribeId = ? and displayed = true order by calendarDefinition.name", (Object)subscribeId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<UserDefinedCalendarConfiguration> getUserDefinedCalendarConfigurations(String subscribeId, boolean visibleOnly) {
        try {
            String query = "from CalendarConfiguration config where subscribeId = ? and config.class = UserDefinedCalendarConfiguration order by calendarDefinition.name";
            if (visibleOnly) {
                query = query.concat(" and visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)subscribeId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedCalendarConfiguration> getPredefinedCalendarConfigurations(String subscribeId, boolean visibleOnly) {
        try {
            String query = "from CalendarConfiguration config where subscribeId = ? and config.class = PredefinedCalendarConfiguration order by calendarDefinition.name";
            if (visibleOnly) {
                query = query.concat(" and visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)subscribeId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedCalendarConfiguration> getPredefinedCalendarConfigurations() {
        try {
            String query = "from CalendarDefinition def where def.class = PredefinedCalendarDefinition order by def.name";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedCalendarDefinition> getHiddenPredefinedCalendarDefinitions(String subscribeId, Set<String> roles) {
        try {
            String query = "from PredefinedCalendarDefinition def where :subscribeId not in (select config.subscribeId from def.userConfigurations config) ";
            for (int i = 0; i < roles.size(); ++i) {
                query = query.concat("and :role" + i + " not in elements(def.defaultRoles) ");
            }
            Query q = this.getSession().createQuery(query);
            q.setString("subscribeId", subscribeId);
            int count = 0;
            for (String role : roles) {
                q.setString("role" + count, role);
                ++count;
            }
            return q.list();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void initCalendar(String subscribeId, Set<String> roles) {
        try {
            if (roles.isEmpty()) {
                return;
            }
            String query = "from PredefinedCalendarDefinition def left join fetch def.defaultRoles role where :subscribeId not in (select config.subscribeId from def.userConfigurations config)";
            if (roles.size() > 0) {
                query = query.concat("and role in (:roles)");
            }
            Query q = this.getSession().createQuery(query);
            q.setString("subscribeId", subscribeId);
            if (roles.size() > 0) {
                q.setParameterList("roles", roles);
            }
            List defs = q.list();
            for (PredefinedCalendarDefinition def : defs) {
                PredefinedCalendarConfiguration config = new PredefinedCalendarConfiguration();
                config.setCalendarDefinition(def);
                config.setSubscribeId(subscribeId);
                this.storeCalendarConfiguration((CalendarConfiguration)config);
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public PredefinedCalendarDefinition getPredefinedCalendarDefinition(Long id) {
        try {
            String query = "from PredefinedCalendarDefinition def left join fetch def.defaultRoles role where def.id = :id";
            Query q = this.getSession().createQuery(query);
            q.setLong("id", id.longValue());
            return (PredefinedCalendarDefinition)q.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public CalendarDefinition getCalendarDefinition(Long id) {
        try {
            return (CalendarDefinition)this.getHibernateTemplate().get(CalendarDefinition.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public CalendarConfiguration getCalendarConfiguration(Long id) {
        try {
            return (CalendarConfiguration)this.getHibernateTemplate().load(CalendarConfiguration.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void deleteCalendarConfiguration(CalendarConfiguration configuration) {
        try {
            this.getHibernateTemplate().delete((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void deleteCalendarDefinition(CalendarDefinition definition) {
        try {
            this.getHibernateTemplate().delete((Object)definition);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<String> getUserRoles() {
        try {
            String query = "select distinct elements(def.defaultRoles) from PredefinedCalendarDefinition def ";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }
}

