/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.VEventStartComparator;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.adapter.ICalendarAdapter;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.portlet.mvc.AbstractAjaxController;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCalendarController
extends AbstractAjaxController {
    private static Log log = LogFactory.getLog(AjaxCalendarController.class);
    private CalendarStore calendarStore;

    protected Map<Object, Object> handleAjaxRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        PortletSession session = request.getPortletSession();
        HashMap<Object, Object> model = new HashMap<Object, Object>();
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        Date startDate = (Date)session.getAttribute("startDate");
        SimpleDateFormat df = new SimpleDateFormat("MM'/'dd'/'yyyy");
        String requestedDate = request.getParameter("startDate");
        if (requestedDate != null && !requestedDate.equals("")) {
            try {
                startDate = df.parse(requestedDate);
                session.setAttribute("startDate", (Object)startDate);
            }
            catch (ParseException ex) {
                log.warn((Object)"Failed to parse starting date for event", (Throwable)ex);
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
        }
        cal.add(5, days);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        model.put("endDate", endDate);
        Period period = new Period(new DateTime(startDate), new DateTime(endDate));
        cal = Calendar.getInstance();
        model.put("today", cal.getTime());
        cal.add(5, 1);
        model.put("tomorrow", cal.getTime());
        List calendars = this.calendarStore.getCalendarConfigurations((String)session.getAttribute("subscribeId"));
        model.put("calendars", calendars);
        ApplicationContext ctx = this.getApplicationContext();
        TreeSet events = new TreeSet(new VEventStartComparator());
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        int index = 0;
        ArrayList<String> errors = new ArrayList<String>();
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)ctx.getBean(callisting.getCalendarDefinition().getClassName());
                    events.addAll(adapter.getEvents(callisting, period, (PortletRequest)request));
                }
                catch (NoSuchBeanDefinitionException ex) {
                    log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (CalendarException ex) {
                    log.warn((Object)ex);
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        log.debug((Object)("events: " + events.size()));
        model.put("timezone", session.getAttribute("timezone"));
        model.put("events", events);
        model.put("colors", colors);
        model.put("hiddenCalendars", hiddenCalendars);
        model.put("errors", errors);
        return model;
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

