/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.VEventStartComparator;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.adapter.ICalendarAdapter;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AjaxEventListController
extends AbstractController {
    private static Log log = LogFactory.getLog(AjaxEventListController.class);
    private CalendarStore calendarStore;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        Date startDate = (Date)session.getAttribute("startDate");
        log.debug((Object)("startDate from session is: " + startDate));
        SimpleDateFormat df = new SimpleDateFormat("MM'/'dd'/'yyyy");
        String requestedDate = request.getParameter("startDate");
        if (requestedDate != null && !requestedDate.equals("")) {
            try {
                startDate = df.parse(requestedDate);
                session.setAttribute("startDate", (Object)startDate);
                log.debug((Object)("adding new start date to session: " + startDate));
            }
            catch (ParseException ex) {
                log.warn((Object)"Failed to parse starting date for event", (Throwable)ex);
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
        }
        cal.add(5, days);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        model.put("endDate", endDate);
        Period period = new Period(new DateTime(startDate), new DateTime(endDate));
        cal = Calendar.getInstance();
        model.put("today", cal.getTime());
        cal.add(5, 1);
        model.put("tomorrow", cal.getTime());
        List calendars = this.calendarStore.getCalendarConfigurations((String)session.getAttribute("subscribeId"));
        model.put("calendars", calendars);
        ApplicationContext ctx = this.getApplicationContext();
        TreeSet events = new TreeSet(new VEventStartComparator());
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        int index = 0;
        ArrayList<String> errors = new ArrayList<String>();
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)ctx.getBean(callisting.getCalendarDefinition().getClassName());
                    events.addAll(adapter.getEvents(callisting, period, request));
                }
                catch (NoSuchBeanDefinitionException ex) {
                    log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (CalendarException ex) {
                    log.warn((Object)ex);
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
                catch (Exception e) {
                    log.error((Object)("Undefined error: " + e.getClass()));
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        log.debug((Object)("events: " + events.size()));
        model.put("timezone", session.getAttribute("timezone"));
        model.put("events", events);
        model.put("colors", colors);
        model.put("hiddenCalendars", hiddenCalendars);
        model.put("errors", errors);
        return new ModelAndView("/ajaxEventList", "model", model);
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

