/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarLinkException;
import edu.yale.its.tp.portlets.calendar.adapter.ICalendarAdapter;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import edu.yale.its.tp.portlets.calendar.service.IInitializationService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarController
extends AbstractController {
    private static Log log = LogFactory.getLog(CalendarController.class);
    private CalendarStore calendarStore;
    private String userToken = null;
    private int defaultDays = 2;
    private List<IInitializationService> initializationServices;

    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        String showCalendar;
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession(true);
        HashMap<Long, String> hiddenCalendars = null;
        Calendar cal = Calendar.getInstance();
        String subscribeId = null;
        if (session.getAttribute("initialized") == null) {
            if (this.userToken == null || this.userToken.equalsIgnoreCase("")) {
                subscribeId = request.getRemoteUser();
            } else {
                Map userinfo = (Map)request.getAttribute("javax.portlet.userinfo");
                subscribeId = (String)userinfo.get(this.userToken);
            }
            if (subscribeId == null) {
                subscribeId = "guest";
            }
            session.setAttribute("subscribeId", (Object)subscribeId);
            List allRoles = this.calendarStore.getUserRoles();
            log.debug((Object)("all roles: " + allRoles));
            HashSet<String> userRoles = new HashSet<String>();
            for (String role : allRoles) {
                if (!request.isUserInRole(role)) continue;
                userRoles.add(role);
            }
            session.setAttribute("userRoles", userRoles);
            session.setAttribute("isAdmin", (Object)request.isUserInRole("calendarAdmin"), 1);
            this.calendarStore.initCalendar(subscribeId, userRoles);
            hiddenCalendars = new HashMap<Long, String>();
            session.setAttribute("hiddenCalendars", hiddenCalendars);
            session.setAttribute("startDate", (Object)cal.getTime());
            session.setAttribute("days", (Object)this.defaultDays);
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)"true");
            session.setMaxInactiveInterval(7200);
            PortletPreferences prefs = request.getPreferences();
            String timezone = prefs.getValue("timezone", "America/New_York");
            session.setAttribute("timezone", (Object)timezone);
        } else {
            hiddenCalendars = (HashMap<Long, String>)session.getAttribute("hiddenCalendars");
            subscribeId = (String)session.getAttribute("subscribeId");
        }
        if ("guest".equalsIgnoreCase(subscribeId)) {
            model.put("guest", true);
        } else {
            model.put("guest", false);
        }
        String hideCalendar = request.getParameter("hideCalendar");
        if (hideCalendar != null) {
            hiddenCalendars.put(Long.valueOf(hideCalendar), "true");
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        if ((showCalendar = request.getParameter("showCalendar")) != null) {
            hiddenCalendars.remove(Long.valueOf(showCalendar));
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        Date startDate = (Date)session.getAttribute("startDate");
        log.debug((Object)("startDate from session is: " + startDate));
        cal.setTime(startDate);
        model.put("startDate", startDate);
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
        }
        model.put("days", days);
        cal.add(5, days);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        model.put("endDate", endDate);
        Period period = new Period(new DateTime(startDate), new DateTime(endDate));
        cal = Calendar.getInstance();
        model.put("today", cal.getTime());
        cal.add(5, 1);
        model.put("tomorrow", cal.getTime());
        List calendars = this.calendarStore.getCalendarConfigurations(subscribeId);
        model.put("calendars", calendars);
        ApplicationContext ctx = this.getApplicationContext();
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        HashMap<Long, String> links = new HashMap<Long, String>();
        int index = 0;
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)ctx.getBean(callisting.getCalendarDefinition().getClassName());
                    links.put(callisting.getId(), adapter.getLink(callisting, period, (PortletRequest)request));
                }
                catch (NoSuchBeanDefinitionException ex) {
                    log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (CalendarLinkException linkEx) {
                    log.warn((Object)linkEx);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        model.put("timezone", session.getAttribute("timezone"));
        model.put("colors", colors);
        model.put("links", links);
        model.put("hiddenCalendars", hiddenCalendars);
        return new ModelAndView("/viewCalendar", "model", model);
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public void setDefaultDays(int defaultDays) {
        this.defaultDays = defaultDays;
    }

    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }
}

