/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarDefinition;
import edu.yale.its.tp.portlets.calendar.PredefinedCalendarDefinition;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import edu.yale.its.tp.portlets.calendar.mvc.CalendarDefinitionForm;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class EditCalendarDefinitionController
extends SimpleFormController {
    private static Log log = LogFactory.getLog(EditCalendarDefinitionController.class);
    private CalendarStore calendarStore;

    protected Object formBackingObject(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedCalendarDefinition definition = this.calendarStore.getPredefinedCalendarDefinition(definitionId);
                CalendarDefinitionForm command = new CalendarDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                return command;
            }
            return new CalendarDefinitionForm();
        }
        return new CalendarDefinitionForm();
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        CalendarDefinitionForm form = (CalendarDefinitionForm)command;
        PredefinedCalendarDefinition definition = null;
        definition = form.getId() > -1L ? this.calendarStore.getPredefinedCalendarDefinition(form.getId()) : new PredefinedCalendarDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setParameters(form.getParameters());
        this.calendarStore.storeCalendarDefinition((CalendarDefinition)definition);
        response.setRenderParameter("action", "administration");
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

