/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.PredefinedCalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.PredefinedCalendarDefinition;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

public class EditCalendarSubscriptionsController
extends AbstractController {
    private static Log log = LogFactory.getLog(EditCalendarSubscriptionsController.class);
    private Map predefinedEditActions;
    private CalendarStore calendarStore;

    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession();
        String subscribeId = (String)session.getAttribute("subscribeId");
        if ("guest".equalsIgnoreCase(subscribeId)) {
            model.put("guest", true);
        } else {
            model.put("guest", false);
        }
        List mycalendars = this.calendarStore.getUserDefinedCalendarConfigurations(subscribeId, false);
        model.put("mycalendars", mycalendars);
        List calendars = this.calendarStore.getPredefinedCalendarConfigurations(subscribeId, false);
        model.put("calendars", calendars);
        Set userRoles = (Set)session.getAttribute("userRoles");
        List definitions = this.calendarStore.getHiddenPredefinedCalendarDefinitions(subscribeId, userRoles);
        model.put("hiddencalendars", definitions);
        model.put("predefinedEditActions", this.predefinedEditActions);
        return new ModelAndView("/editCalendars", "model", model);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        Long id = Long.parseLong(request.getParameter("id"));
        String actionCode = request.getParameter("actionCode");
        PortletSession session = request.getPortletSession();
        if (actionCode.equals("delete")) {
            CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
            this.calendarStore.deleteCalendarConfiguration(config);
            Map hidden = (Map)session.getAttribute("hiddenCalendars");
            hidden.remove(config.getId());
        } else if (actionCode.equals("show")) {
            CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
            config.setDisplayed(true);
            this.calendarStore.storeCalendarConfiguration(config);
            Map hidden = (Map)session.getAttribute("hiddenCalendars");
            hidden.remove(config.getId());
        } else if (actionCode.equals("hide")) {
            CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
            config.setDisplayed(false);
            this.calendarStore.storeCalendarConfiguration(config);
            Map hidden = (Map)session.getAttribute("hiddenCalendars");
            hidden.remove(config.getId());
        } else if (actionCode.equals("showNew")) {
            String subscribeId = (String)session.getAttribute("subscribeId");
            PredefinedCalendarDefinition definition = (PredefinedCalendarDefinition)this.calendarStore.getCalendarDefinition(id);
            log.debug((Object)("definition to save " + definition.toString()));
            PredefinedCalendarConfiguration config = new PredefinedCalendarConfiguration();
            config.setSubscribeId(subscribeId);
            config.setCalendarDefinition(definition);
            this.calendarStore.storeCalendarConfiguration((CalendarConfiguration)config);
        }
    }

    public void setPredefinedEditActions(Map predefinedEditActions) {
        this.predefinedEditActions = predefinedEditActions;
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

