/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.mvc.controller;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.CalendarDefinition;
import edu.yale.its.tp.portlets.calendar.UserDefinedCalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.UserDefinedCalendarDefinition;
import edu.yale.its.tp.portlets.calendar.dao.CalendarStore;
import edu.yale.its.tp.portlets.calendar.mvc.CalendarListingCommand;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.mvc.SimpleFormController;

public class EditUserHttpICalController
extends SimpleFormController {
    private static Log log = LogFactory.getLog(EditUserHttpICalController.class);
    private CalendarStore calendarStore;

    protected Object formBackingObject(PortletRequest request) throws Exception {
        PortletSession session = request.getPortletSession();
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long configurationId = Long.parseLong(id);
            if (configurationId > -1L) {
                CalendarConfiguration listing = this.calendarStore.getCalendarConfiguration(configurationId);
                log.debug((Object)("retrieved " + listing.toString()));
                CalendarListingCommand command = new CalendarListingCommand();
                command.setId(listing.getId());
                command.setName(listing.getCalendarDefinition().getName());
                command.setUrl((String)listing.getCalendarDefinition().getParameters().get("url"));
                command.setSubscribeId(listing.getSubscribeId());
                command.setDisplayed(listing.isDisplayed());
                return command;
            }
            String subscribeId = (String)session.getAttribute("subscribeId");
            CalendarListingCommand command = new CalendarListingCommand();
            command.setSubscribeId(subscribeId);
            return command;
        }
        String subscribeId = (String)session.getAttribute("subscribeId");
        CalendarListingCommand command = new CalendarListingCommand();
        command.setSubscribeId(subscribeId);
        return command;
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        CalendarListingCommand form = (CalendarListingCommand)command;
        UserDefinedCalendarConfiguration config = null;
        UserDefinedCalendarDefinition definition = null;
        if (form.getId() > -1L) {
            config = (UserDefinedCalendarConfiguration)this.calendarStore.getCalendarConfiguration(form.getId());
            definition = config.getCalendarDefinition();
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
        } else {
            definition = new UserDefinedCalendarDefinition();
            definition.setClassName("httpIcalAdapter");
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.calendarStore.storeCalendarDefinition((CalendarDefinition)definition);
            config = new UserDefinedCalendarConfiguration();
            config.setCalendarDefinition(definition);
            config.setSubscribeId(form.getSubscribeId());
            config.setDisplayed(form.isDisplayed());
        }
        this.calendarStore.storeCalendarConfiguration((CalendarConfiguration)config);
        response.setRenderParameter("action", "editSubscriptions");
    }

    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

