/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.url;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.url.IUrlCreator;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.lang.time.DateFormatUtils;

public class CalendarkeyUrlCreatorImpl
implements IUrlCreator {
    public String constructUrl(CalendarConfiguration calendarListing, Period period, HttpServletRequest request) {
        String username;
        String baseUrl = (String)calendarListing.getCalendarDefinition().getParameters().get("baseUrl");
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            finalUrl.append("/");
        }
        if (null == (username = request.getRemoteUser()) || "".equals(username)) {
            throw new CalendarException("user not logged in");
        }
        finalUrl.append(username);
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getStart().getTime(), (String)"yyyyMMdd"));
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getEnd().getTime(), (String)"yyyyMMdd"));
        return finalUrl.toString();
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, PortletRequest request) {
        String username;
        String baseUrl = (String)calendarListing.getCalendarDefinition().getParameters().get("baseUrl");
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            finalUrl.append("/");
        }
        if (null == (username = request.getRemoteUser()) || "".equals(username)) {
            throw new CalendarException("user not logged in");
        }
        finalUrl.append(username);
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getStart().getTime(), (String)"yyyyMMdd"));
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getEnd().getTime(), (String)"yyyyMMdd"));
        return finalUrl.toString();
    }
}

