/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.url;

import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.portlet.ICASProxyTicketService;
import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.url.IUrlCreator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CasProxyUrlCreatorImpl
implements IUrlCreator {
    private Log log = LogFactory.getLog(this.getClass());
    private ICASProxyTicketService proxyTicketService;

    public void setProxyTicketService(ICASProxyTicketService proxyTicketService) {
        this.proxyTicketService = proxyTicketService;
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, HttpServletRequest request) {
        String configuredUrl = (String)calendarListing.getCalendarDefinition().getParameters().get("url");
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.log.warn((Object)"CasifiedICalFeed requested with a null session");
            throw new CalendarException();
        }
        CASReceipt receipt = (CASReceipt)session.getAttribute("CasReceipt");
        if (receipt == null) {
            this.log.warn((Object)"CasifiedICalFeed cannot find a CAS receipt object");
            throw new CalendarException();
        }
        String proxyTicket = this.proxyTicketService.getCasServiceToken(receipt, configuredUrl);
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(configuredUrl);
        if (proxyTicket == null) {
            this.log.warn((Object)("No CAS ticket could be obtained for " + configuredUrl + ".  Returning empty event list."));
            throw new CalendarException();
        }
        String separator = configuredUrl.contains("?") ? "&" : "?";
        finalUrl.append(separator);
        finalUrl.append("ticket=");
        finalUrl.append(proxyTicket);
        return finalUrl.toString();
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, PortletRequest request) {
        String configuredUrl = (String)calendarListing.getCalendarDefinition().getParameters().get("url");
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            this.log.warn((Object)"CasifiedICalFeed requested with a null session");
            throw new CalendarException();
        }
        CASReceipt receipt = (CASReceipt)session.getAttribute("CasReceipt");
        if (receipt == null) {
            this.log.warn((Object)"CasifiedICalFeed cannot find a CAS receipt object");
            throw new CalendarException();
        }
        String proxyTicket = this.proxyTicketService.getCasServiceToken(receipt, configuredUrl);
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(configuredUrl);
        if (proxyTicket == null) {
            this.log.warn((Object)("No CAS ticket could be obtained for " + configuredUrl + ".  Returning empty event list."));
            throw new CalendarException();
        }
        String separator = configuredUrl.contains("?") ? "&" : "?";
        finalUrl.append(separator);
        finalUrl.append("ticket=");
        finalUrl.append(proxyTicket);
        return finalUrl.toString();
    }
}

