/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.portlets.calendar.url;

import edu.yale.its.tp.portlets.calendar.CalendarConfiguration;
import edu.yale.its.tp.portlets.calendar.adapter.CalendarException;
import edu.yale.its.tp.portlets.calendar.url.IUrlCreator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringTemplateUrlCreatorImpl
implements IUrlCreator {
    private Log log = LogFactory.getLog(this.getClass());
    private final String USERNAME_TOKEN = "@USERNAME@";
    private final String START_DATE_TOKEN = "@STARTDATE@";
    private final String END_DATE_TOKEN = "@ENDDATE@";
    private final String URL_ENCODING = "UTF-8";
    private final String DEFAULT_DATE_FORMAT = "yyyyMMdd";

    public String constructUrl(CalendarConfiguration configuration, Period period, PortletRequest request) {
        PortletSession session = request.getPortletSession();
        if (session == null) {
            throw new CalendarException();
        }
        String username = (String)session.getAttribute("username");
        return this.constructUrlInternal(configuration, period, username);
    }

    public String constructUrl(CalendarConfiguration configuration, Period period, HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session == null) {
            throw new CalendarException();
        }
        String username = (String)session.getAttribute("username");
        return this.constructUrlInternal(configuration, period, username);
    }

    public String constructUrlInternal(CalendarConfiguration configuration, Period period, String username) {
        String url = (String)configuration.getCalendarDefinition().getParameters().get("url");
        try {
            url = url.replace("@USERNAME@", URLEncoder.encode(username, "UTF-8"));
            if (url.contains("@STARTDATE@") || url.contains("@ENDDATE@")) {
                String urlDateFormat = (String)configuration.getCalendarDefinition().getParameters().get("urlDateFormat");
                if (urlDateFormat == null) {
                    urlDateFormat = "yyyyMMdd";
                }
                String startString = URLEncoder.encode(DateFormatUtils.format((long)period.getStart().getTime(), (String)urlDateFormat), "UTF-8");
                url = url.replace("@STARTDATE@", startString);
                String endString = URLEncoder.encode(DateFormatUtils.format((long)period.getEnd().getTime(), (String)urlDateFormat), "UTF-8");
                url = url.replace("@ENDDATE@", endString);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
        }
        return url;
    }
}

