/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.VEventStartComparator;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.IViewSelector;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxCalendarController
implements ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ICalendarSetDao calendarSetDao;
    private IViewSelector viewSelector;
    private ApplicationContext applicationContext;
    private AjaxPortletSupportService ajaxPortletSupportService;

    @RequestMapping(params={"action=events"})
    public void getEventList(ActionRequest request, ActionResponse response) throws Exception {
        PortletSession session = request.getPortletSession();
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletPreferences prefs = request.getPreferences();
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        Calendar cal = null;
        String timezone = (String)session.getAttribute("timezone");
        Date startDate = (Date)session.getAttribute("startDate");
        SimpleDateFormat df = new SimpleDateFormat("MM'/'dd'/'yyyy");
        String requestedDate = request.getParameter("startDate");
        if (requestedDate != null && !requestedDate.equals("")) {
            try {
                startDate = df.parse(requestedDate);
                cal = Calendar.getInstance();
                cal.setTime(startDate);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 1);
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                cal.add(14, -TimeZone.getTimeZone(timezone).getOffset(cal.getTimeInMillis()));
                startDate = cal.getTime();
                session.setAttribute("startDate", (Object)cal.getTime());
            }
            catch (ParseException ex) {
                this.log.warn((Object)"Failed to parse starting date for event", (Throwable)ex);
            }
        }
        if (cal == null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)session.getAttribute("startDate"));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 1);
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.add(14, -TimeZone.getTimeZone(timezone).getOffset(cal.getTimeInMillis()));
        }
        startDate = cal.getTime();
        this.log.debug((Object)("start date: " + cal));
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
                if (!prefs.isReadOnly("days")) {
                    prefs.setValue("days", Integer.toString(days));
                    prefs.store();
                }
            }
            catch (NumberFormatException ex) {
                this.log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
            catch (ReadOnlyException ex) {
                this.log.error((Object)"Failed to set 'days' preference because it is read only", (Throwable)ex);
            }
            catch (IOException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
            catch (ValidatorException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
        }
        cal.add(5, days);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        model.put("endDate", endDate);
        Period period = new Period(new DateTime(startDate), new DateTime(endDate));
        cal = Calendar.getInstance();
        model.put("today", cal.getTime());
        cal.add(5, 1);
        model.put("tomorrow", cal.getTime());
        CalendarSet<?> set = this.calendarSetDao.getCalendarSet((PortletRequest)request);
        Set<?> calendars = set.getConfigurations();
        model.put("calendars", calendars);
        TreeSet<VEvent> events = new TreeSet<VEvent>(new VEventStartComparator());
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        int index = 0;
        ArrayList<String> errors = new ArrayList<String>();
        TimeZone userTz = TimeZone.getTimeZone(timezone);
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                    for (CalendarEvent event : adapter.getEvents(callisting, period, (PortletRequest)request)) {
                        if (event.getStartDate().getTimeZone() == null) {
                            int offset = userTz.getOffset(event.getStartDate().getDate().getTime());
                            event.getStartDate().getDate().setTime(event.getStartDate().getDate().getTime() - (long)offset);
                            event.getEndDate().getDate().setTime(event.getEndDate().getDate().getTime() - (long)offset);
                            if (!period.includes((Date)event.getStartDate().getDate(), 1) && !period.includes((Date)event.getEndDate().getDate(), 2)) continue;
                            events.add(event);
                            continue;
                        }
                        events.add(event);
                    }
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (Exception ex) {
                    this.log.warn((Object)ex);
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        this.log.debug((Object)("events: " + events.size()));
        model.put("timezone", session.getAttribute("timezone"));
        model.put("events", events);
        model.put("colors", colors);
        model.put("hiddenCalendars", hiddenCalendars);
        model.put("errors", errors);
        model.put("viewName", this.viewSelector.getEventListViewName((PortletRequest)request));
        this.ajaxPortletSupportService.redirectAjaxResponse("ajax/jspView", model, request, response);
    }

    @Autowired(required=true)
    public void setCalendarSetDao(ICalendarSetDao calendarSetDao) {
        this.calendarSetDao = calendarSetDao;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }
}

