/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.IViewSelector;
import org.jasig.portlet.calendar.service.IInitializationService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class CalendarController
implements ApplicationContextAware {
    public static final String PREFERENCE_DISABLE_PREFERENCES = "disablePreferences";
    public static final String PREFERENCE_DISABLE_ADMINISTRATION = "disableAdministration";
    protected final Log log = LogFactory.getLog(this.getClass());
    private ICalendarSetDao calendarSetDao;
    private List<IInitializationService> initializationServices;
    private IViewSelector viewSelector;
    private ApplicationContext applicationContext;

    @RequestMapping
    public ModelAndView getCalendar(PortletRequest request) {
        String showCalendar;
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            for (IInitializationService service : this.initializationServices) {
                service.initialize(request);
            }
        }
        PortletPreferences prefs = request.getPreferences();
        HashMap<String, Object> model = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        String username = (String)session.getAttribute("username");
        if ("guest".equalsIgnoreCase(username)) {
            model.put("guest", true);
        } else {
            model.put("guest", false);
        }
        String hideCalendar = request.getParameter("hideCalendar");
        if (hideCalendar != null) {
            hiddenCalendars.put(Long.valueOf(hideCalendar), "true");
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        if ((showCalendar = request.getParameter("showCalendar")) != null) {
            hiddenCalendars.remove(Long.valueOf(showCalendar));
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        Date startDate = (Date)session.getAttribute("startDate");
        this.log.debug((Object)("startDate from session is: " + startDate));
        cal.setTime(startDate);
        model.put("startDate", startDate);
        int days = (Integer)session.getAttribute("days");
        String timePeriod = request.getParameter("timePeriod");
        if (timePeriod != null && !timePeriod.equals("")) {
            try {
                days = Integer.parseInt(timePeriod);
                session.setAttribute("days", (Object)days);
                if (!prefs.isReadOnly("days")) {
                    prefs.setValue("days", Integer.toString(days));
                    prefs.store();
                }
            }
            catch (NumberFormatException ex) {
                this.log.warn((Object)"Failed to parse desired time period", (Throwable)ex);
            }
            catch (ReadOnlyException ex) {
                this.log.error((Object)"Failed to set 'days' preference because it is read only", (Throwable)ex);
            }
            catch (IOException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
            catch (ValidatorException ex) {
                this.log.warn((Object)"Failed to store the 'days' preference", (Throwable)ex);
            }
        }
        model.put("days", days);
        cal.add(5, days);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        model.put("endDate", endDate);
        Period period = new Period(new DateTime(startDate), new DateTime(endDate));
        cal = Calendar.getInstance();
        model.put("today", cal.getTime());
        cal.add(5, 1);
        model.put("tomorrow", cal.getTime());
        CalendarSet<?> set = this.calendarSetDao.getCalendarSet(request);
        Set<?> calendars = set.getConfigurations();
        model.put("calendars", calendars);
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        HashMap<Long, String> links = new HashMap<Long, String>();
        int index = 0;
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                    links.put(callisting.getId(), adapter.getLink(callisting, period, request));
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (CalendarLinkException linkEx) {
                    this.log.warn((Object)linkEx);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        model.put("timezone", session.getAttribute("timezone"));
        model.put("colors", colors);
        model.put("links", links);
        model.put("hiddenCalendars", hiddenCalendars);
        Boolean disablePrefs = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_PREFERENCES, "false"));
        model.put(PREFERENCE_DISABLE_PREFERENCES, disablePrefs);
        Boolean disableAdmin = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_ADMINISTRATION, "false"));
        model.put(PREFERENCE_DISABLE_ADMINISTRATION, disableAdmin);
        return new ModelAndView(this.viewSelector.getCalendarViewName(request), "model", model);
    }

    @Autowired(required=true)
    public void setCalendarSetDao(ICalendarSetDao calendarSetDao) {
        this.calendarSetDao = calendarSetDao;
    }

    @Required
    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

