/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.url;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.url.IUrlCreator;

public class CalendarkeyUrlCreatorImpl
implements IUrlCreator {
    public String constructUrl(CalendarConfiguration calendarListing, Period period, HttpServletRequest request) {
        String username;
        String baseUrl = calendarListing.getCalendarDefinition().getParameters().get("baseUrl");
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            finalUrl.append("/");
        }
        if (null == (username = request.getRemoteUser()) || "".equals(username)) {
            throw new CalendarException("user not logged in");
        }
        finalUrl.append(username);
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getStart().getTime(), (String)"yyyyMMdd"));
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getEnd().getTime(), (String)"yyyyMMdd"));
        return finalUrl.toString();
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, PortletRequest request) {
        String username;
        String baseUrl = calendarListing.getCalendarDefinition().getParameters().get("baseUrl");
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            finalUrl.append("/");
        }
        if (null == (username = request.getRemoteUser()) || "".equals(username)) {
            throw new CalendarException("user not logged in");
        }
        finalUrl.append(username);
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getStart().getTime(), (String)"yyyyMMdd"));
        finalUrl.append("/");
        finalUrl.append(DateFormatUtils.format((long)period.getEnd().getTime(), (String)"yyyyMMdd"));
        return finalUrl.toString();
    }
}

