/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.url;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fortuna.ical4j.model.Period;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.url.IUrlCreator;
import org.jasig.portlet.cas.ICASProxyTicketService;

public class CasProxyUrlCreatorImpl
implements IUrlCreator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ICASProxyTicketService proxyTicketService;

    public void setProxyTicketService(ICASProxyTicketService proxyTicketService) {
        this.proxyTicketService = proxyTicketService;
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, HttpServletRequest request) {
        String configuredUrl = calendarListing.getCalendarDefinition().getParameters().get("url");
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.log.warn((Object)"CasifiedICalFeed requested with a null session");
            throw new CalendarException();
        }
        Assertion receipt = (Assertion)session.getAttribute("CasReceipt");
        if (receipt == null) {
            this.log.warn((Object)"CasifiedICalFeed cannot find a CAS receipt object");
            throw new CalendarException();
        }
        String proxyTicket = this.proxyTicketService.getCasServiceToken(receipt, configuredUrl);
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(configuredUrl);
        if (proxyTicket == null) {
            this.log.warn((Object)("No CAS ticket could be obtained for " + configuredUrl + ".  Returning empty event list."));
            throw new CalendarException();
        }
        String separator = configuredUrl.contains("?") ? "&" : "?";
        finalUrl.append(separator);
        finalUrl.append("ticket=");
        finalUrl.append(proxyTicket);
        return finalUrl.toString();
    }

    public String constructUrl(CalendarConfiguration calendarListing, Period period, PortletRequest request) {
        String configuredUrl = calendarListing.getCalendarDefinition().getParameters().get("url");
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            this.log.warn((Object)"CasifiedICalFeed requested with a null session");
            throw new CalendarException();
        }
        Assertion receipt = (Assertion)session.getAttribute("CasReceipt");
        if (receipt == null) {
            this.log.warn((Object)"CasifiedICalFeed cannot find a CAS receipt object");
            throw new CalendarException();
        }
        String proxyTicket = this.proxyTicketService.getCasServiceToken(receipt, configuredUrl);
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(configuredUrl);
        if (proxyTicket == null) {
            this.log.warn((Object)("No CAS ticket could be obtained for " + configuredUrl + ".  Returning empty event list."));
            throw new CalendarException();
        }
        String separator = configuredUrl.contains("?") ? "&" : "?";
        finalUrl.append(separator);
        finalUrl.append("ticket=");
        finalUrl.append(proxyTicket);
        return finalUrl.toString();
    }
}

