/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarDefinition;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.PredefinedCalendarDefinition;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.mvc.CalendarPreferencesCommand;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"EDIT"})
public class EditCalendarSubscriptionsController {
    private static final String FORM_NAME = "calendarPreferencesCommand";
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> predefinedEditActions = new HashMap();
    private List<String> timeZones = null;
    private CalendarStore calendarStore;

    @RequestMapping
    public ModelAndView viewEditOptions(RenderRequest request, RenderResponse response) {
        return this.viewSubscriptions(request, response);
    }

    @RequestMapping(params={"action=editSubscriptions"})
    public ModelAndView viewSubscriptions(RenderRequest request, RenderResponse response) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession();
        String subscribeId = (String)session.getAttribute("username");
        if ("guest".equalsIgnoreCase(subscribeId)) {
            model.put("guest", true);
        } else {
            model.put("guest", false);
        }
        PortletPreferences prefs = request.getPreferences();
        model.put("timezoneReadOnly", prefs.isReadOnly("timezone"));
        List mycalendars = this.calendarStore.getUserDefinedCalendarConfigurations(subscribeId, false);
        model.put("mycalendars", mycalendars);
        List calendars = this.calendarStore.getPredefinedCalendarConfigurations(subscribeId, false);
        model.put("calendars", calendars);
        Set userRoles = (Set)session.getAttribute("userRoles");
        List definitions = this.calendarStore.getHiddenPredefinedCalendarDefinitions(subscribeId, userRoles);
        model.put("hiddencalendars", definitions);
        model.put("predefinedEditActions", this.predefinedEditActions);
        return new ModelAndView("/editCalendars", "model", model);
    }

    @RequestMapping(params={"action=deleteUserCalendar"})
    public void removeSubscription(ActionRequest request, ActionResponse response, @RequestParam(value="configurationId") Long id) {
        CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
        this.calendarStore.deleteCalendarConfiguration(config);
        PortletSession session = request.getPortletSession();
        Map hidden = (Map)session.getAttribute("hiddenCalendars");
        hidden.remove(config.getId());
        response.setRenderParameter("action", "editSubscriptions");
    }

    @RequestMapping(params={"action=showCalendar"})
    public void showCalendar(ActionRequest request, ActionResponse response, @RequestParam(value="configurationId") Long id) {
        CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
        config.setDisplayed(true);
        this.calendarStore.storeCalendarConfiguration(config);
        PortletSession session = request.getPortletSession();
        Map hidden = (Map)session.getAttribute("hiddenCalendars");
        hidden.remove(config.getId());
        response.setRenderParameter("action", "editSubscriptions");
    }

    @RequestMapping(params={"action=hideCalendar"})
    public void hideCalendar(ActionRequest request, ActionResponse response, @RequestParam(value="configurationId") Long id) {
        CalendarConfiguration config = this.calendarStore.getCalendarConfiguration(id);
        config.setDisplayed(false);
        this.calendarStore.storeCalendarConfiguration(config);
        PortletSession session = request.getPortletSession();
        Map hidden = (Map)session.getAttribute("hiddenCalendars");
        hidden.remove(config.getId());
        response.setRenderParameter("action", "editSubscriptions");
    }

    @RequestMapping(params={"action=addSharedCalendar"})
    public void addSharedCalendar(ActionRequest request, ActionResponse response, @RequestParam(value="definitionId") Long id) {
        PortletSession session = request.getPortletSession();
        String subscribeId = (String)session.getAttribute("username");
        PredefinedCalendarDefinition definition = (PredefinedCalendarDefinition)this.calendarStore.getCalendarDefinition(id);
        this.log.debug((Object)("definition to save " + definition.toString()));
        PredefinedCalendarConfiguration config = new PredefinedCalendarConfiguration();
        config.setSubscribeId(subscribeId);
        config.setCalendarDefinition((CalendarDefinition)definition);
        this.calendarStore.storeCalendarConfiguration((CalendarConfiguration)config);
        response.setRenderParameter("action", "editSubscriptions");
    }

    @RequestMapping(params={"action=editPreferences"})
    public void updatePreferences(ActionRequest request, ActionResponse response, @ModelAttribute(value="calendarPreferencesCommand") CalendarPreferencesCommand form) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        if (!prefs.isReadOnly("timezone")) {
            prefs.setValue("timezone", form.getTimezone());
            prefs.store();
            PortletSession session = request.getPortletSession();
            session.setAttribute("timezone", (Object)form.getTimezone());
        }
        response.setRenderParameter("action", "editSubscriptions");
    }

    @ModelAttribute(value="timezones")
    public List<String> getTimeZones() {
        return this.timeZones;
    }

    @ModelAttribute(value="calendarPreferencesCommand")
    public CalendarPreferencesCommand getForm(PortletRequest request) throws Exception {
        CalendarPreferencesCommand form = new CalendarPreferencesCommand();
        PortletPreferences prefs = request.getPreferences();
        form.setTimezone(prefs.getValue("timezone", "America/New_York"));
        return form;
    }

    @Required
    @Resource(name="predefinedEditActions")
    public void setPredefinedEditActions(Map<String, String> predefinedEditActions) {
        this.predefinedEditActions = predefinedEditActions;
    }

    @Required
    @Resource(name="timeZones")
    public void setTimeZones(List<String> timeZones) {
        this.timeZones = timeZones;
    }

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }
}

